package com.horizon.third.service.imp;

import com.horizon.core.tree.TreeModel;
import com.horizon.third.build.OrgDataBuilderHolder;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.third.service.api.OrgDataQueryApi;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author pengys 2021/10/25.
 */
@Service
public class OrgDataQueryService implements OrgDataQueryApi {
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    @Override
    public List<User> findUserByOrgId(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findUserByOrgId(type,orgId);
    }

    /**
     * 根据组织机构的类型和id查找对应给组织机构数据
     * @param type 组织机构类型
     * @param orgId 组织机构ID
     * @return
     */
    @Override
    public OrgData getOrgDataById(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().getOrgDataById(type,orgId);
    }

    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    @Override
    public List<OrgData> findChildrenData(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findChildrenData(type,orgId);
    }

    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @param isAllChild
     * @return
     */
    @Override
    public List<OrgData> findChildrenData(String type, String orgId, boolean isAllChild) {
        return OrgDataBuilderHolder.getBuilder().findChildrenData(type,orgId,isAllChild);
    }
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return
     */
    @Override
    public OrgData getRootNode(String type) {
        return OrgDataBuilderHolder.getBuilder().getRootNode(type);
    }

    /**
     * 根据传参值模糊检索用户
     * </P> 根据searchMax属性只搜索最多searchMax值个用户
     * @param param
     * @return 单个对象
     */
    @Override
    public List<User> findUserLikeParam(String param, int searchMax) {
        return OrgDataBuilderHolder.getBuilder().getUserLikeParam(param,searchMax);
    }

    /**
     * 根据传参值检索所有相似用户
     *
     * @param param
     * @return 单个对象
     */
    @Override
    public List<User> findUserLikeParam(String param) {
        return OrgDataBuilderHolder.getBuilder().getUserLikeParam(param);
    }
    /**
     * 根据用户id检索用户
     *
     * @param id
     * @return 单个对象
     */
    @Override
    public User getUserById(String id) {
        return OrgDataBuilderHolder.getBuilder().getUserById(id);
    }

    /**
     *  查询所有用户
     * @return
     */
    @Override
    public List<User> findAllUser() {
        return OrgDataBuilderHolder.getBuilder().findAllUser();
    }

    /**
     * 根据登录名检索用户
     *
     * @param loginName
     * @return 单个对象
     */
    @Override
    public User getUserByLoginName(String loginName) {
        return OrgDataBuilderHolder.getBuilder().getUserByLoginName(loginName);
    }

    /**
     * 根据用户id查找用户所在的组织机构
     * @param userId
     * @return
     */
    @Override
    public List<OrgData> findOrgForUserByUserId(String userId) {
        return OrgDataBuilderHolder.getBuilder().getOrgForUserByUserId(userId);
    }

    /**
     * 根据用户id和组织机构类型查找用户所在的组织机构
     * @param type
     * @param userId
     * @return
     */
    @Override
    public List<OrgData> findOrgForUserByUserId(String type, String userId) {
        return OrgDataBuilderHolder.getBuilder().getOrgForUserByUserId(type,userId);
    }
    /**
     * 根据组织机构的类型和id查找所有的上级
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    @Override
    public List<OrgData> findParentToRoot(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findParentToRoot(type,orgId);
    }

    /**
     * 根据组织机构的类型查找对应的组织机构数据
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return
     */
    @Override
    public List<OrgData> findOrgData(String type) {
        return OrgDataBuilderHolder.getBuilder().findOrgData(type);
    }

    /**
     * 获取所有组织机构类型数据
     * @param
     * @return
     */
    @Override
    public List<OrgData> findOrgData() {
        return OrgDataBuilderHolder.getBuilder().findOrgData();
    }

    /**
     * 根据类型获得内存树
     *
     * @param type
     *            D:部门书；G:群组；P:岗位；R:角色
     * @return
     */
    @Override
    public TreeModel<OrgData> getOrgTree(String type) {
        return OrgDataBuilderHolder.getBuilder().getOrgTree(type);
    }
}
