package com.horizon.third.service.imp;

import com.horizon.cache.api.HCacheClient;
import com.horizon.common.base.Objects;
import com.horizon.third.OrgConstant;
import com.horizon.third.service.api.OrgDataCacheApi;
import com.horizon.utils.HorizonPool;
import org.springframework.stereotype.Service;

/**
 * @author pengys 2021/11/17.
 */
@Service
public class OrgDataCacheService implements OrgDataCacheApi, OrgConstant {

    /**
     * 清除所有类型的组织机构缓存包含部门,岗位,群组,角色,用户
     */
    public void clearAllOrgCache(){
        this.clearDeptCache();
        this.clearGroupCache();
        this.clearPositionCache();
        this.clearRoleCache();
        this.clearUserCache();
    }

    /**
     * 根据组织机构的类型清除对应的组织机构数据
     * @param type (部门:D,群组:G,岗位:P,角色:R,用户:U)
     */
    public void clearOrgCache(String type){
        if (Objects.equal(DEPT,type)){
            this.clearDeptCache();
        }else if(Objects.equal(GROUP,type)){
            this.clearGroupCache();
        }else if(Objects.equal(POSITION,type)){
            this.clearPositionCache();
        }else if(Objects.equal(ROLE,type)){
            this.clearRoleCache();
        }else if(Objects.equal(USER,type)){
            this.clearUserCache();
        }
    }

    /**
     * 清除所有的部门缓存
     */
    public void clearDeptCache(){
        if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT)) {
            HCacheClient.remove(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT);
        }
    }
    /**
     * 清除所有的群组缓存
     */
    public void clearGroupCache(){
        if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP)) {
            HCacheClient.remove(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP);
        }
    }
    /**
     * 清除所有的岗位缓存
     */
    public void clearPositionCache(){
        if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION)) {
            HCacheClient.remove(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION);
        }

    }

    /**
     * 清除所有的角色缓存
     */
    public void clearRoleCache(){
        if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE)) {
            HCacheClient.remove(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE);
        }
    }

    /**
     * 清除所有的用户缓存
     */
    public void clearUserCache(){
        if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_USER)) {
            HCacheClient.remove(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_USER);
        }
    }

}
