package com.horizon.third.service.api;

import com.horizon.core.tree.TreeModel;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * @author pengys 2021/10/14.
 */
 public interface OrgDataQueryApi {
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return  List<User>
     */
     List<User> findUserByOrgId(String type, String orgId);

    /**
     * 根据组织机构的类型和id查找对应给组织机构数据
     * @param type 组织机构类型
     * @param orgId 组织机构ID
     * @return OrgData
     */
     OrgData getOrgDataById(String type, String orgId);
    
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的子级
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return  List<OrgData>
     */
    List<OrgData> findChildrenData(String type, String orgId);

    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @param isAllChild
     * @return List<OrgData>
     */
     List<OrgData> findChildrenData(String type, String orgId, boolean isAllChild);

    /**
     * 根据组织机构的类型查询该组织机构的根级
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return  OrgData
     */
     OrgData getRootNode(String type);

    /**
     * 根据传参值模糊检索用户
     * </P> 根据searchMax属性只搜索最多searchMax值个用户
     * @param param
     * @return List<User>
     */
     List<User> findUserLikeParam(String param, int searchMax);

    /**
     * 根据传参值检索所有相似用户
     *
     * @param param
     * @return List<User>
     */
     List<User> findUserLikeParam(String param);

    /**
     * 根据用户id检索用户
     *
     * @param id
     * @return User
     */
     User getUserById(String id);

    /**
     *  查询所有用户
     * @return   List<User>
     */
     List<User> findAllUser();

    /**
     * 根据登录名检索用户
     *
     * @param loginName
     * @return User
     */
     User getUserByLoginName(String loginName);

    /**
     * 根据用户id查找用户所在的组织机构
     * @param userId
     * @return  List<OrgData>
     */
     List<OrgData> findOrgForUserByUserId(String userId);
    
    /**
     * 根据用户id和组织机构类型查找用户所在的组织机构
     * @param type
     * @param userId
     * @return  List<OrgData>
     */
     List<OrgData> findOrgForUserByUserId(String type, String userId);

    /**
     * 根据组织机构的类型和id查找所有的上级
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return  List<OrgData>
     */
     List<OrgData> findParentToRoot(String type, String orgId);

    /**
     * 根据组织机构的类型查找对应的组织机构数据
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return  List<OrgData>
     */
     List<OrgData> findOrgData(String type);

    /**
     * 获取所有组织机构类型数据
     * @param
     * @return  List<OrgData>
     */
    List<OrgData> findOrgData();

    /**
     * 根据类型获得内存树
     *
     * @param type D:部门书；G:群组；P:岗位；R:角色
     * @return
     */
    TreeModel<OrgData> getOrgTree(String type);

}
