package com.horizon.third.relation;

import com.horizon.common.base.Objects;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 所有下属人员，
 * <p>
 * 如果给定userId不是领导职务，则返回null
 *
 * @author mwr
 *
 */
public class Subordinates extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {

        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            List<String> list = Splitter.on(SUBJECTION_FIX).omitEmptyStrings().splitToList(userId);
            String id = list.get(0);
            User user = super.getUserById(subPrefix(id));
            if (Objects.equal("F", user.getOperType())) {
                String deptId = user.getFirstDept();
                List<OrgData> childrenData = super.findChildrenData(DEPT, deptId, true);
                if (childrenData != null && !childrenData.isEmpty()) {
                    for (OrgData data : childrenData) {
                        List<User> users = super.findUserByOrgId(DEPT, data.getId());
                        if (users != null && !users.isEmpty()) {
                            for (User u : users) {
                                String fixId =  u.getFixId() + "/" + DEPT_FIX + data.getId();
                                idList.add(fixId);
                            }
                        }
                    }
                }
            }

        }
        return idList;
    }
}
