package com.horizon.third.relation;

import com.horizon.common.base.Objects;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 直接下属人员，
 * <p>
 * 如果给定userId不是领导职务，则返回null
 * 
 * @author mwr
 *
 */
public class Subordinate extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {

        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String id = this.subUserId(userId);
            User user = super.getUserById(id);
            if (Objects.equal("F", user.getOperType())) {
                String deptId = user.getFirstDept();
                List<User> users = super.findUserByOrgId(DEPT, deptId);
                if (users != null && !users.isEmpty()) {
                    for (User u : users) {
                        String fixId = u.getFixId() + "/" + DEPT_FIX + deptId;
                        idList.add(fixId);
                    }
                }
            }
        }
        return idList;
    }

    private String subUserId(String userId) {
        List<String> list = Splitter.on(SUBJECTION_FIX).omitEmptyStrings().splitToList(userId);
        String id = list.get(0);
        return subPrefix(id);

    }
}
