package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 同步人员
 * 
 * @author mwr
 *
 */
public class SameDeptUser extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {
        List<String> userIdList = Lists.newArrayList();
        for (String userId : userIds) {
            String deptId = getDeptId(userId);
            List<User> users = super.findUserByOrgId(DEPT, deptId);
            if (users != null && !users.isEmpty()){
                for (User user : users) {
                    String fixId =  user.getFixId() + "/" + DEPT_FIX + deptId;
                    userIdList.add(fixId);
                }
            }
        }
        return userIdList;
    }

}
