package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 下级岗位人员
 *
 * @author mwr
 *
 */
public class LowerPositionUser extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {

        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String positionId = super.getPositionId(userId);
            List<OrgData> children = super.findChildrenData(POSITION, positionId);
            for (OrgData child : children) {
                String orgId = child.getId();
                List<User> users = super.findUserByOrgId(POSITION, orgId);
                if (users != null && !users.isEmpty()){
                    for (User user : users) {
                        String fixId = user.getFixId() + "/" + POSITION_FIX + orgId;
                        idList.add(fixId);
                    }
                }

            }
        }
        return idList;
    }
}
