package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;

import java.util.List;

/**
 * 下级岗位
 * 
 * @author mwr
 *
 */
public class LowerPosition extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {
        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String positionId = super.getPositionId(userId);
            List<OrgData> childrenData = super.findChildrenData(POSITION, positionId);
            for (OrgData orgData : childrenData) {
                idList.add(orgData.getFixId());
            }
        }
        return idList;
    }

}
