package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

import java.util.List;

/**
 * 上级岗位人员
 *
 * @author mwr
 *
 */
public class HigherPositionUser extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {
        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String positionId = super.getPositionId(userId);
            if (StringUtil.hasValue(positionId)){
                OrgData orgData = super.getOrgDataById(POSITION, positionId);
                String parentId = orgData.getParentId();
                parentId = StringUtil.hasValue(parentId)? parentId:positionId;
                if (StringUtil.hasValue(parentId)) {
                    List<User> users = super.findUserByOrgId(POSITION, parentId);
                    if (users != null || !users.isEmpty()) {
                        for (User user : users) {
                            String fixId = user.getFixId() + "/" + POSITION_FIX + parentId;
                            idList.add(fixId);
                        }
                    }
                }
            }
        }
        return idList;
    }
}
