package com.horizon.third.relation;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.utils.StringUtil;

import java.util.List;

/**
 * 上级岗位
 * 
 * @author mwr
 *
 */
public class HigherPosition extends RelationAdapter {

    @Override
    public List<String> getRelations(String... users) {
        List<String> idList = Lists.newArrayList();
        for (String userId : users) {
            String positionId = getPositionId(userId);
            if (StringUtil.hasValue(positionId)) {
                OrgData root = super.getRootNode(POSITION);
                String rootId = root.getId();
                OrgData orgData = super.getOrgDataById(POSITION, positionId);
                String parentId = null;
                if (orgData != null){
                    parentId = orgData.getParentId();
                }
                parentId = StringUtil.hasValue(parentId) ? parentId : positionId;
                if (!Objects.equal(rootId,parentId)){
                    String fixId = POSITION_FIX + parentId;
                    idList.add(fixId);
                }
            }
        }
        return idList;
    }
}
