package com.horizon.third.relation;

import java.util.List;

import com.horizon.common.base.Joiner;
import com.horizon.common.collect.Lists;
import com.horizon.core.tree.TreeModel;
import com.horizon.core.tree.TreeNode;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

/**
 * 所有上级领导
 * 
 * @author mwr
 *
 */
public class HigherLeaders extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {
        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String deptId = super.getDeptId(userId);
            List<OrgData> parents = super.findParentToRoot(DEPT, deptId);
            if (parents != null || !parents.isEmpty()) {
                for (OrgData orgData : parents) {
                    String orgId = orgData.getId();
                    List<User> orgUsers = super.findUserByOrgId(DEPT, orgId);
                    List<User> users = filterManageUser("C", orgUsers);
                    for (User user : users) {
                        String fixId = Joiner.on(SUBJECTION_FIX).join(user.getFixId(), DEPT_FIX + orgId);
                        idList.add(fixId);
                    }
                }
            }
        }
        return idList;
    }
}
