package com.horizon.third.relation;

import com.horizon.common.base.Joiner;
import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

import java.util.List;

/**
 * 上级主管领导
 * 
 * @author mwr
 *
 */
public class HigherLeader extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {

        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String deptId = super.getDeptId(userId);
            OrgData data = super.getOrgDataById(DEPT, deptId);
            String parentId = null;
            if (data != null){
                parentId = data.getParentId();
            }
            parentId = StringUtil.hasValue(parentId)? parentId:deptId;
            List<User> orgUsers = super.findUserByOrgId(DEPT, parentId);
            if (orgUsers != null || !orgUsers.isEmpty()) {
                for (User user : orgUsers) {
                    String id = Joiner.on(SUBJECTION_FIX).join(user.getFixId(),DEPT_FIX + parentId);
                    idList.add(id);
                }
            }
            List<User> users = filterManageUser("C", orgUsers);
            if (users != null || !users.isEmpty()) {
                for (User user : users) {
                    String id = Joiner.on(SUBJECTION_FIX).join(user.getFixId(),DEPT_FIX + parentId);
                    idList.add(id);
                }
            }

        }
        return idList;
    }

}
