package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 上级部门所有人员(含直接子部门)
 * 
 * @author mwr
 *
 */
public class HigherDeptAndSub extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {
        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String deptId = super.getDeptId(userId);
            OrgData orgData = super.getOrgDataById(DEPT, deptId);
            String parentId = orgData.getParentId();
            List<User> orgUsers = super.findUserByOrgId(DEPT, parentId);
            if (orgUsers != null || !orgUsers.isEmpty()) {
                for (User user : orgUsers) {
                    String fixId =  user.getFixId() + "/" + DEPT_FIX + parentId;
                    idList.add(fixId);
                }
            }
            List<OrgData> childrenData = super.findChildrenData(DEPT, parentId);
            for (OrgData child : childrenData) {
                String orgId = child.getId();
                List<User> users = super.findUserByOrgId(DEPT, orgId);
                if (users != null && !users.isEmpty()){
                    for (User user : users) {
                        String fixId =  user.getFixId() + "/" + DEPT_FIX + orgId;
                        idList.add(fixId);
                    }
                }
            }
        }
        return idList;
    }
}
