package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

import java.util.List;

/**
 * 上级部门所有人员(不含子部门)
 * 
 * @author mwr
 *
 */
public class HigherDept extends RelationAdapter {

    @Override
    public List<String> getRelations(String... usersIds) {
        List<String> idList = Lists.newArrayList();
        for (String userId : usersIds) {
            String deptId = super.getDeptId(userId);
            OrgData orgData = super.getOrgDataById(DEPT, deptId);
            String parentId = orgData.getParentId();
            parentId = StringUtil.hasValue(parentId)? parentId:deptId;
            List<User> users = super.findUserByOrgId(DEPT, parentId);
            if (users != null && !users.isEmpty()) {
                for (User user : users) {
                    String id = user.getFixId() + "/" + DEPT_FIX + parentId;
                    idList.add(id);
                }
            }
        }
        return idList;
    }
}
