package com.horizon.third.relation;

import com.horizon.common.collect.Lists;
import com.horizon.third.adapter.RelationAdapter;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * 部门接口人
 * 
 * @author mwr
 *
 */
public class DeptLiaison extends RelationAdapter {

    @Override
    public List<String> getRelations(String... userIds) {

        List<String> idList = Lists.newArrayList();
        for (String userId : userIds) {
            String deptId = super.getDeptId(userId);
            List<User> orgUsers = super.findUserByOrgId(DEPT, deptId);
            List<User> users = filterManageUser("I", orgUsers);
            if (users != null && !users.isEmpty()){
                for (User user : users) {
                    String fixId = user.getFixId() + "/" + DEPT_FIX + deptId;
                    idList.add(fixId);
                }
            }
        }
        return idList;
    }
}
