package com.horizon.third.init;

import java.util.Map;

/**
 * 用来存储初始化时所设置的instance的类
 *
 * @author lichao 2016年10月25日
 */
public class WorkflowAdapterFactory {

    /**
     * 接口适配器<br/>
     * 值需继承WorkflowBaseAdapther类
     */
    private Map<String, String> workflowAdaptherMap;

    /**
     * 相对关系<br/>
     * 值需实现RelationUsers接口
     */
    private Map<String, String> relationMap;

    /**
     * 组织机构构建器<br/>
     * 值需继承OrgBuilder
     */
    private String organizationBuilder;

    /**
     * 组织机构构建器<br/>
     * 值需继承OrgBuilder
     */
    private String orgDataQuery;

    /**
     * 初始化租户空间时所需要的类<br/>
     * 值需要实现InitDataService接口
     */
    private Map<String, String> initTenantModule;

    public Map<String, String> getWorkflowAdaptherMap() {

        return workflowAdaptherMap;
    }

    public void setWorkflowAdaptherMap(Map<String, String> workflowAdaptherMap) {

        this.workflowAdaptherMap = workflowAdaptherMap;
    }

    public Map<String, String> getRelationMap() {

        return relationMap;
    }

    public void setRelationMap(Map<String, String> relationMap) {

        this.relationMap = relationMap;
    }

    public String getOrganizationBuilder() {

        return organizationBuilder;
    }

    public void setOrganizationBuilder(String organizationBuilder) {

        this.organizationBuilder = organizationBuilder;
    }

    public Map<String, String> getInitTenantModule() {

        return initTenantModule;
    }

    public void setInitTenantModule(Map<String, String> initTenantModule) {

        this.initTenantModule = initTenantModule;
    }

    public String getOrgDataQuery() {
        return orgDataQuery;
    }

    public void setOrgDataQuery(String orgDataQuery) {
        this.orgDataQuery = orgDataQuery;
    }
}
