package com.horizon.third.entity;

import java.io.Serializable;
import java.util.List;

import com.horizon.common.base.Objects;

/**
 * 用户实体类
 * 
 * @author mwr
 *
 */
public class User implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private String id;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 登录名称
     */
    private String loginName;

    /**
     * 登录密码
     */
    private String passwd;

    /**
     * 部门ID
     */
    private List<String> department;

    /**
     * 顺序号
     */
    private Integer orderNo;

    /**
     * 职务
     */
    private String operType;

    public User() {
    }

    public User(String id) {
        this.id = id;
    }

    public User(String id, String userName) {
        this.id = id;
        this.userName = userName;
    }

    public String getId() {

        return id;
    }

    public Integer getOrderNo() {

        return orderNo;
    }

    public void setOrderNo(Integer orderNo) {

        this.orderNo = orderNo;
    }

    public void setId(String id) {

        this.id = id;
    }

    public String getUserName() {

        return userName;
    }

    public void setUserName(String userName) {

        this.userName = userName;
    }

    public String getLoginName() {

        return loginName;
    }

    public void setLoginName(String loginName) {

        this.loginName = loginName;
    }

    public String getPasswd() {

        return passwd;
    }

    public void setPasswd(String passwd) {

        this.passwd = passwd;
    }

    public String getOperType() {

        return operType;
    }

    public void setOperType(String operType) {

        this.operType = operType;
    }

    /**
     * 获得所有部门
     * 
     * @return
     */
    public List<String> getDepartment() {

        return department;
    }

    public void setDepartment(List<String> department) {

        this.department = department;
    }

    /**
     * 获得主部门
     * 
     * @return
     * @modify zhangsk 2018年1月30日 将变量id 改为firstDeptId,以免与成员变量的id混淆
     */
    public String getFirstDept() {

        String firstDeptId = "";
        if (department != null && !department.isEmpty()) {
            firstDeptId = department.get(0);
        }
        return firstDeptId;
    }

    public String getFixId() {

        return "U_" + getId();
    }

    public String getJobName() {

        String jobName = "";
        if (Objects.equal("F", operType)) {
            jobName = "(负责人)";

        } else if (Objects.equal("C", operType)) {
            jobName = "(主管领导)";

        } else if (Objects.equal("I", operType)) {
            jobName = "(接口人)";
        }
        return jobName;
    }

    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof User) {
            User user = (User) obj;
            if (Objects.equal(user.getId(),id)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {

        int result = 17;
        result = 37 * result + Objects.hashCode(id);
        return result;
    }

}
