package com.horizon.third.entity;

import java.util.List;

import com.horizon.common.collect.Lists;
import com.horizon.core.common.entity.TreeEntity;

/**
 * 组织机构实体类
 *
 * @author mwr
 *
 */
public class OrgData extends TreeEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 类型
     */
    private String type;

    private String code;

    private String deptId;

    private String isParent;

    private List<User> users = Lists.newArrayList();

    public List<User> getUsers() {

        return users;
    }

    public void setUsers(List<User> users) {

        this.users = users;
    }

    public void addUser(User user) {

        users.add(user);
    }

    public String getFixId() {

        return getType().toUpperCase() + "_" + getId();
    }

    public List<String> getFixUserIds() {

        List<String> fixUsers = Lists.newArrayList();
        if (users != null && !users.isEmpty()) {
            for (User user : users) {
                String id = user.getFixId() + "/" + getFixId();
                fixUsers.add(id);
            }
        }

        return fixUsers;
    }

    public String getType() {

        return type;
    }

    public void setType(String type) {

        this.type = type;
    }

    public String getCode() {

        return code;
    }

    public void setCode(String code) {

        this.code = code;
    }

    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getIsParent() {
        return isParent;
    }

    public void setIsParent(String isParent) {
        this.isParent = isParent;
    }
}
