package com.horizon.third.data;

import java.io.IOException;
import java.net.URL;
import java.util.List;

import com.horizon.common.base.Charsets;
import com.horizon.common.io.Resources;
import com.horizon.exception.HorizonException;

/**
 * 组织机构测试数据
 * （不对外提供）
 * @author mwr
 *
 */
public class TestData {

    /**
     * 部门
     * 
     * @return
     */
    public static String getDepts() {

        return getFileLines("com/horizon/third/data/dept.json");
    }

    /**
     * 群组
     * 
     * @return
     */
    public static String getGroups() {

        return getFileLines("com/horizon/third/data/group.json");
    }

    /**
     * 岗位
     * 
     * @return
     */
    public static String getPositions() {

        return getFileLines("com/horizon/third/data/position.json");
    }

    /**
     * 用户
     * 
     * @return
     */
    public static String getUsers() {

        return getFileLines("com/horizon/third/data/user.json");
    }

    private static String getFileLines(String fileName) {

        StringBuilder builder = new StringBuilder();
        URL url= Resources.getResource(fileName);
        try {
            List<String> lines = Resources.readLines(url, Charsets.UTF_8);
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    builder.append(line.trim());
                }
            }
        } catch (IOException e) {
            throw new HorizonException("初始化内存数据失败，读取资源文件失败 ");
        }

        return builder.toString();
    }
}
