package com.horizon.third.build;

import com.horizon.cache.api.HCacheClient;
import com.horizon.core.tree.TreeModel;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.HorizonPool;

import java.util.Collections;
import java.util.List;

/**
 * 组机构构建工厂
 *
 * @author mwr
 * @modify lichao 2017-7-27 将老的cache框架调用修改为新的统一cache框架
 * @modify pengys 2022-10-12 将OrgDirector标记为过时,请注入com.horizon.third.service.api.OrgDataQueryApi
 *
 */
@Deprecated
public enum OrgDirector {

    INSTANCE,

    DEPT {
        @Override
        public TreeModel<OrgData> tree() {
            TreeModel<OrgData> orgData = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT)) {
                orgData = buildTree(builder.depts());
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT, orgData, 0L);
            } else {
                orgData = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT);
            }
            return orgData;
        }
        public List<OrgData> base() {
            List<OrgData> orgData = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT)) {
                orgData = builder.depts();
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT, orgData, 0L);
            } else {
                orgData = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_DEPT);
            }
            return orgData;
        }
    },
    GROUP {
        @Override
        public TreeModel<OrgData> tree() {
            TreeModel<OrgData> orgData = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP)) {
                orgData = buildTree(builder.groups());
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP, orgData, 0L);
            } else {
                orgData = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP);
            }
            return orgData;
        }
        @Override
        public List<OrgData> base() {
            List<OrgData> groups = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP)) {
                groups = builder.groups();
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP, groups, 0l);
            } else {
                groups = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_GROUP);
            }
            return groups;
        }
    },
    POSITION {
        @Override
        public TreeModel<OrgData> tree() {
            TreeModel<OrgData> orgData = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION)) {
                orgData = buildTree(builder.positions());
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION, orgData, 0L);
            } else {
                orgData = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION);
            }

            return orgData;
        }
        @Override
        public List<OrgData> base() {
            List<OrgData> positions = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION)) {
                positions = builder.positions();
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION, positions, 0l);
            } else {
                positions = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_POSITION);
            }
            return positions;
        }
    },
    ROLE {
        @Override
        public TreeModel<OrgData> tree() {
            TreeModel<OrgData> orgData = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE)) {
                orgData = buildTree(builder.roles());
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE, orgData, 0L);
            } else {
                orgData = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE);
            }
            return orgData;
        }
        @Override
        public List<OrgData> base() {
            List<OrgData> roles = null;
            if (!HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE)) {
                roles = builder.roles();
                HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE, roles, 0l);
            } else {
                roles = HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_ROLE);
            }
            return roles;
        }
    },
    USER {
        @Override
        public List<User> getVaules() {

            if (HCacheClient.keyExists(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_USER)) {
                return HCacheClient.get(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_USER);
            }
            List<User> users = builder.users();
            HCacheClient.put(HorizonPool.HORIZON_CACHE_VALUE, HorizonPool.HORIZON_CACHE_USER, users, 0L);
            return users;
        }
    };

    private static OrgBuilder builder;

    /**
     * 构建结果信息
     *
     * @param newBuilder
     */
    public void build(OrgBuilder newBuilder) {

        builder = newBuilder;
        builder.init();
    }

    public List<User> getVaules() {

        return Collections.emptyList();
    }

    public TreeModel<OrgData> tree() {

        return null;
    }
    public List<OrgData> base() {
        return Collections.emptyList();
    }


    /**
     * 构建树
     *
     * @param datas
     * @return
     */
    protected TreeModel<OrgData> buildTree(List<OrgData> datas) {

        TreeModel<OrgData> tree = null;
        if (datas != null) {
            tree = new TreeModel<OrgData>().creat(datas);
        }
        return tree;
    }

}
