package com.horizon.third.build;

import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;

import java.util.List;

/**
 * @author pengys 2021/10/13.
 */
public interface OrgDataQuery{

    /**
     * 根据部门id获取部门下的人员
     * @param deptId
     * @return
     */
     List<User> findUserByDeptId(String dbIdentifier,String deptId);

    /**
     * 根据群组id获取群组下的人员
     * @param groupId
     * @return
     */
     List<User> findUserByGroupId(String dbIdentifier,String groupId);

    /**
     * 根据岗位id获取岗位下的人员
     * @param positionId
     * @return
     */
     List<User> findUserByPositionId(String dbIdentifier, String positionId);

    /**
     * 根据角色id获取角色下的人员
     * @param roleId
     * @return
     */
     List<User> findUserByRoleId(String dbIdentifier, String roleId);

    /**
     * 根据部门id获取下级部门
     * @param deptId
     * @return
     */
    List<OrgData> findDeptByParentId(String dbIdentifier, String deptId);

    /**
     * 根据群组id获取下级群组
     * @param groupId
     * @return
     */
    List<OrgData> findGroupByParentId(String dbIdentifier, String groupId);

    /**
     * 根据岗位id获取下级岗位
     * @param positionId
     * @return
     */
    List<OrgData> findPositionByParentId(String dbIdentifier, String positionId);

    /**
     * 根据角色id获取下级角色
     * @param roleId
     * @return
     */
    List<OrgData> findRoleByParentId(String dbIdentifier, String roleId);

    /**
     * 根据用户id查找用户
     * @param id
     * @return
     */
     User getUserById(String dbIdentifier, String id);

    /**
     * 查询所有用户
     * @return
     */
     List<User> findAllUser(String dbIdentifier);
    /**
     * loginName查找用户
     * @param loginName
     * @return
     */
     User getUseByLoginName(String dbIdentifier, String loginName);

    /**
     * 根据查询参数模糊查找用户
     * @param param
     * @return
     */
     List<User> findUserLikeParam(String dbIdentifier, String param);

    /**
     * 根据传参值模糊检索用户
     * </P> 根据searchMax属性只搜索最多searchMax值个用户,searchMax<=0时为无效值,无效值请返回所有
     * @param param
     * @return 单个对象
     */
     List<User> findUserLikeParam(String dbIdentifier, String param, int searchMax);

    /**
     * 根据用户id查找用户所在的部门
     * @param userId
     * @return
     */
     List<OrgData> findDeptByUserId(String dbIdentifier, String userId);

    /**
     * 根据用户id查找用户所在的群组
     * @param userId
     * @return
     */
    List<OrgData> findGroupByUserId(String dbIdentifier, String userId);

    /**
     * 根据用户id查找用户所在的岗位
     * @param userId
     * @return
     */
    List<OrgData> findPositionByUserId(String dbIdentifier, String userId);

    /**
     * 根据用户id查找用户所在的角色
     * @param userId
     * @return
     */
    List<OrgData> findRoleByUserId(String dbIdentifier, String userId);
    /**
     * 查找根部门
     * <p>
     * 由子类实现
     *
     */
    OrgData getDeptRoot(String dbIdentifier);
    /**
     * 查找根群组
     * <p>
     * 由子类实现
     *
     */
    OrgData getGroupRoot(String dbIdentifier);
    /**
     * 查找根岗位
     * <p>
     * 由子类实现
     *
     */
    OrgData getPositionRoot(String dbIdentifier);

    /**
     * 查找根角色
     * <p>
     * 由子类实现
     *
     */
    OrgData getRoleRoot(String dbIdentifier);

    /**
     * 根据部门id查询部门
     * @param deptId
     * @return
     */
    OrgData getDeptById(String dbIdentifier, String deptId);
    /**
     * 根据群组id查询部门
     * @param groupId
     * @return
     */
    OrgData getGroupById(String dbIdentifier, String groupId);
    /**
     * 根据岗位id查询部门
     * @param positionId
     * @return
     */
    OrgData getPositionById(String dbIdentifier, String positionId);
    /**
     * 根据角色id查询部门
     * @param roleId
     * @return
     */
    OrgData getRoleById(String dbIdentifier, String roleId);


}
