package com.horizon.third.build;

import com.horizon.common.base.Objects;
import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.third.service.OrgDataDefaultBuilder;
import com.horizon.third.service.OrgDataQueryBuilder;
import com.horizon.third.init.WorkflowAdapterFactory;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.ReflectHelper;
import com.horizon.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author pengys 2021年10月15日
 */
public class OrgDataBuilderHolder {
    private final static Logger logger = LoggerFactory.getLogger(OrgDataBuilderHolder.class);

    private static OrgDataBuilder orgDataBuilder;

    private OrgDataBuilderHolder(){

    }
    public static OrgDataBuilder getBuilder() {
        if (orgDataBuilder == null) {
            synchronized (OrgDataBuilderHolder.class) {
                if (orgDataBuilder == null) {
                    String loadAll = HorizonPorps.getConfig("orgData.loadAll");
                    if (Objects.equal("false", loadAll)) {
                        WorkflowAdapterFactory adapterFactory = SpringContextHolder.getBean(WorkflowAdapterFactory.class);
                        String orgClass = adapterFactory.getOrgDataQuery();
                        if (StringUtil.hasValue(orgClass)) {
                            OrgDataQuery orgDataQuery = ReflectHelper.initClass(orgClass);
                            orgDataBuilder = new OrgDataQueryBuilder(orgDataQuery);
                        }else {
                            logger.error("horizon.properties文件中的orgData.loadAll=false时,必须实现com.horizon.third.build.OrgDataQuery");
                        }
                    }else {
                        orgDataBuilder = new OrgDataDefaultBuilder();
                    }

                }
            }
        }
        return orgDataBuilder;
    }

}
