package com.horizon.third.build;

import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.third.init.WorkflowAdapterFactory;
import com.horizon.utils.ReflectHelper;
import com.horizon.utils.StringUtil;

/**
 * 
 * @author lichao 2017年9月1日
 */
public class OrgBuilderHolder {

    private static OrgBuilder orgDataBuilder;

    private OrgBuilderHolder(){
    }
    public static OrgBuilder getBuilder() {
        if (orgDataBuilder == null) {
            synchronized (OrgDataBuilderHolder.class) {
                if (orgDataBuilder == null) {
                    WorkflowAdapterFactory adapterFactory = SpringContextHolder.getBean(WorkflowAdapterFactory.class);
                    String orgClass = adapterFactory.getOrganizationBuilder();
                    if (StringUtil.hasValue(orgClass)) {
                        orgDataBuilder = ReflectHelper.initClass(orgClass);
                    }else {
                        orgDataBuilder = new DefBuilder();
                    }
                }
            }
        }
        return orgDataBuilder;
    }

}
