package com.horizon.third.build;

import java.util.List;

import com.horizon.common.collect.Lists;
import com.horizon.third.data.TestData;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.json.JsonUtil;

/**
 * 组织机构默认构建器
 * 
 * @author mwr
 *
 */
public final class DefBuilder extends OrgBuilder {

    @Override
    public List<OrgData> depts() {

        String json = TestData.getDepts();
        return getJsonToList(json);
    }

    @Override
    public List<OrgData> groups() {

        String json = TestData.getGroups();
        return getJsonToList(json);
    }

    @Override
    public List<OrgData> positions() {

        String json = TestData.getPositions();
        return getJsonToList(json);
    }

    @Override
    public List<User> users() {

        String json = TestData.getUsers();
        return JsonUtil.fromJsonArray(json, User.class);
    }

    @Override
    public List<OrgData> roles() {

        return Lists.newArrayList();
    }

    protected List<OrgData> getJsonToList(String json) {

        return JsonUtil.fromJsonArray(json, OrgData.class);
    }

}
