package com.horizon.third.adapter;

import com.horizon.common.base.Preconditions;
import com.horizon.common.base.Splitter;

import com.horizon.core.tree.TreeModel;
import com.horizon.third.OrgConstant;

import com.horizon.third.build.OrgDataBuilderHolder;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import java.util.List;

/**
 * 接口适配器基类
 *
 * @author mwr
 */
public class WorkflowBaseAdapther implements OrgConstant {

    /**
     * 根据用户ID获得部门ID
     *
     * @param userId 用户ID
     * @return
     */
  

    protected String getDeptId(String userId) {

        Preconditions.checkNotNull(userId, "[Adapter] 请求的参数 userId 为 null ");
        String id = this.subPrefix(userId);
        User user = OrgDataBuilderHolder.getBuilder().getUserById(id);
        return user.getFirstDept();
    }

    /**
     * 根据部门ID，获取直接父部门ID。
     *
     * @param deptId 部门ID
     * @return
     */
    protected String getParentId(String deptId) {
        Preconditions.checkNotNull(deptId, "请求的参数 deptId 为 null ");
        OrgData orgdata = OrgDataBuilderHolder.getBuilder().getOrgDataById(DEPT, deptId);
        String parentId = null;
        if (orgdata != null ){
            parentId = orgdata.getParentId();
        }
        return parentId;
    }
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    public List<User> findUserByOrgId(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findUserByOrgId(type,orgId);
    }

    /**
     * 根据组织机构的类型和id查找对应给组织机构数据
     * @param type 组织机构类型
     * @param orgId 组织机构ID
     * @return
     */
    public OrgData getOrgDataById(String type, String orgId){
        return OrgDataBuilderHolder.getBuilder().getOrgDataById(type, orgId);
    }

    /**
     * 根据组织机构的类型和id查找所有的上级
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    public List<OrgData> findParentToRoot(String type, String orgId){
        return OrgDataBuilderHolder.getBuilder().findParentToRoot(type, orgId);
    }

    /**
     * 查询所有用户数据
     * @return
     */
    public List<User> findAllUser() {
        return OrgDataBuilderHolder.getBuilder().findAllUser();
    }
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @param isAllChild
     * @return
     */
    public List<OrgData> findChildrenData(String type, String orgId, boolean isAllChild) {
        return OrgDataBuilderHolder.getBuilder().findChildrenData(type,orgId,isAllChild);
    }
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
    public List<OrgData> findChildrenData(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findChildrenData(type,orgId,false);
    }
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return
     */
    public OrgData getRootNode(String type) {
        return OrgDataBuilderHolder.getBuilder().getRootNode(type);
    }
    /**
     * 据用户id检索用户
     * @param userId
     * @return
     */
    protected User getUserById(String userId){
        Preconditions.checkNotNull(userId, "请求的参数 userId 为 null ");
        return OrgDataBuilderHolder.getBuilder().getUserById(userId);
    }
    /**
     * 根据登录名检索用户
     *
     * @param loginName
     * @return 单个对象
     */
    protected User getUserByLoginName(String loginName) {
        Preconditions.checkNotNull(loginName, "请求的参数 loginName 为 null ");
        User user = OrgDataBuilderHolder.getBuilder().getUserByLoginName(loginName);
        return user;
    }
    /**
     * 根据传参值模糊检索用户
     * </P> 根据searchMax属性值只搜索最多searchMax值个用户
     * @param param
     * @return 单个对象
     */
    protected List<User> getUserLikeParam(String param) {
        Preconditions.checkNotNull(param, "请求的参数 parm 为 null ");
        String searchMax = HorizonPorps.getConfig("orgData.searchMax");
        List<User> users = null;
        if (StringUtil.hasValue(searchMax)){
            Integer userNum = Integer.valueOf(searchMax);
            users = OrgDataBuilderHolder.getBuilder().getUserLikeParam(param, userNum);
        }else {
            users = OrgDataBuilderHolder.getBuilder().getUserLikeParam(param);
        }
        return users;
    }

    /**根据用户检索用户所在的组织机构
     * @param userId 用户ID
     * @return
     */
    protected List<OrgData> getOrgForUserByUserId(String userId) {
        Preconditions.checkNotNull(userId, "请求的参数 userId 为 null ");
        return OrgDataBuilderHolder.getBuilder().getOrgForUserByUserId(userId);
    }
    /**根据用户检索用户所在的组织机构
     * @param userId 用户ID
     * @return
     */
    protected List<OrgData> getOrgForUserByUserId(String type,String userId) {
        Preconditions.checkNotNull(userId, "请求的参数 userId 为 null ");
        return OrgDataBuilderHolder.getBuilder().getOrgForUserByUserId(type,userId);
    }
    /**
     * 根据类型获得内存树
     *
     * @param type
     *            D：部门书；G：群组；P：岗位；R：角色
     * @return
     */
    @Deprecated
    protected TreeModel<OrgData> getOrgTree(String type) {
       return OrgDataBuilderHolder.getBuilder().getOrgTree(type);
    }


    /**
     * 部门树
     *
     * @return
     */
    @Deprecated
    protected TreeModel<OrgData> getDetpTree() {
        return this.getOrgTree(DEPT);
    }
    /**
     * 根据用户
     *
     * @param type D:部门;G:群组;P:岗位;R:角色
     * @return
     */
    public List<User> getUserByOrgId(String type, String orgId) {
        return OrgDataBuilderHolder.getBuilder().findUserByOrgId(type,orgId);
    }

    /**
     * 删除ID的前缀
     *
     * @param id
     * @return
     */
    protected String subPrefix(String id) {
       if (StringUtil.hasValue(id)){
           id = id.replaceAll("\\]", "");
           id = id.replaceAll("\\[", "");
           id = id.replaceAll(SPLITCHAR, "");
           List<String> list = Splitter.on(AGENT_SPLITCHAR).omitEmptyStrings().splitToList(id);
           id = list.get(0);
           int idx = id.indexOf('_');
           if (idx > -1) {
               id = id.substring(idx + 1);
           }
       }
        return id;
    }


}
