package com.horizon.third.adapter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.horizon.third.Persistence;
import com.horizon.third.WorkCalendar;
import com.horizon.third.init.WorkflowAdapterInit;
import com.horizon.utils.DateUtil;

/**
 * 工作日历适配器
 * 
 * @author mwr
 *
 */
public class WorkCalendarAdapter extends WorkflowBaseAdapther implements WorkCalendar {

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.horizon.third.WorkCalendar#getWorkdaysFromTwoDate(java.util.Date,
     * java.util.Date, int, java.lang.String)
     */
    @Override
    public int getWorkdaysFromTwoDate(Date date1, Date date2, int datetype, String identifier) {

        String[] arrs = DateUtil.getSubtractResArray(date1, date2);
        int day = -1;
        switch (datetype) {
            case 0:
                String strDate1 = DateUtil.formatDateTime(date1, "yyyy-MM-dd");
                String strDate2 = DateUtil.formatDateTime(date2, "yyyy-MM-dd");
                day = getWorkDaysCount(strDate1, strDate2, identifier);
                break;
            case 1:
                day = Integer.parseInt(arrs[0]);
                break;
            case 2:
                day = Integer.parseInt(arrs[1]);
                break;
            case 3:
                day = Integer.parseInt(arrs[2]);
                break;
            default:
                break;
        }
        return day;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.horizon.third.WorkCalendar#getWorkdaysFromTwoDate(java.lang.String,
     * java.lang.String, int, java.lang.String)
     */
    @Override
    public int getWorkdaysFromTwoDate(String date1, String date2, int datetype, String identifier) {

        Date dDate1 = DateUtil.getDate(date1);
        Date dDate2 = DateUtil.getDate(date2);
        return getWorkdaysFromTwoDate(dDate2, dDate1, datetype, identifier);
    }

    @Override
    public Date getDateAfter(Date date, int datetype, int days, String identifier) {

        Date dDate = null;
        switch (datetype) {
            case 0:
                dDate = getWorkDay(date, days, identifier);
                if (dDate == null) {
                    dDate = DateUtil.addDateYear(date, 10);
                }
                break;
            case 1:
                dDate = DateUtil.addDateDay(date, days);
                break;
            default:
                break;
        }
        return dDate;
    }

    /**
     * 从日历工作日设置表中获取对应的工作日数目
     * 
     * @param date
     *            指定时间
     * @param days
     * @param identifier
     * @return
     */
    private Date getWorkDay(Date date, int days, String identifier) {

        Persistence access = (Persistence) WorkflowAdapterInit.getWorkflowAdapthers("access");
        String sql = "SELECT T.F_DATE FROM TW_HZ_ATTENDANCE_WORKDAY T  WHERE T.F_DATE >? ORDER BY T.F_DATE";
        List<String> list = new ArrayList<String>();
        list.add(DateUtil.formatDateTime(date));
        List<Map<String,Object>> result = access.getPagingMap(sql, list, 1, days);
        Date workDate = null;
        if (result != null && !result.isEmpty()) {
            Map<String, Object> l = result.get(result.size() - 1);
            String strDate = l.get("f_date") + " 00:00:00";
            workDate = DateUtil.getDate(strDate);
        }
        return workDate;
    }

    /**
     * 从日历工作日设置表中获取对应的工作日数目
     * 
     * @param date1
     *            开始时间
     * @param date2
     *            结束时间
     * @return
     */
    private int getWorkDaysCount(String date1, String date2, String identifier) {

        Persistence access = (Persistence) WorkflowAdapterInit.getWorkflowAdapthers("access");
        String sql = "SELECT ID FROM TW_HZ_ATTENDANCE_WORKDAY T  WHERE T.F_DATE >=? AND T.F_DATE<=?";
        List<String> list = new ArrayList<String>();
        list.add(date1);
        list.add(date2);
        return access.getRsCount(sql, list, identifier);
    }

}
