package com.horizon.third.adapter;

import com.horizon.common.base.Objects;
import com.horizon.common.base.Predicate;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18n;
import com.horizon.third.Persistence;
import com.horizon.third.TenantInfo;
import com.horizon.third.init.WorkflowAdapterInit;
import com.horizon.utils.HorizonPorps;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 租户信息接口实现类
 * 
 * @author yufang
 *
 */
public class TenantAdapter extends WorkflowBaseAdapther implements TenantInfo {

    /**
     * 租户列表，进行初步的缓存
     */
    protected static List<Map<String, String>> tenants = new CopyOnWriteArrayList<Map<String, String>>();

    public TenantAdapter() {

        initTenant();
    }

    /**
     * 初始化租户列表
     */
    protected void initTenant() {
        tenants.clear();
        Persistence access = (Persistence) WorkflowAdapterInit.getWorkflowAdapthers("access");
        String identifier = access.getDefaultDatabaseIdentifier();
        String initFlag = HorizonPorps.getConfig("initFlag");
        Map<String, String> system = Maps.newHashMap();
        system.put("tenantcode", identifier);
        system.put("tenantname", Hi18n.getVal("workflow", "systemSpace"));
        system.put("dbidentifierflag", identifier);
        tenants.add(system);

        if ("1".equals(initFlag)) {
            String sql = "SELECT TENANTNAME,TENANTCODE,IDENTIFIER FROM TW_HZ_TENANT";
            List<Map<String, Object>> list = access.getMultiMap(sql, null, identifier);
            if (list != null && !list.isEmpty()) {
                for (Map<String, Object> tenant : list) {
                    Map<String, String> map = Maps.newHashMap();
                    map.put("tenantcode", (String) tenant.get("tenantcode"));
                    map.put("tenantname", (String) tenant.get("tenantname"));
                    map.put("dbidentifierflag", (String) tenant.get("identifier"));
                    tenants.add(map);
                }
            }

        }

    }

    @Override
    public void reload() {

        initTenant();
    }

    @Override
    public List<Map<String, String>> getTenants() {

        return tenants;
    }

    @Override
    public Map<String, String> getTenantName(String tenantCode) {

        return getTenant(tenantCode);
    }

    private Map<String, String> getTenant(final String tenantCode) {

        Collection<Map<String, String>> filterList = Collections2.filter(getTenants(),
                new Predicate<Map<String, String>>() {

                    @Override
                    public boolean apply(Map<String, String> map) {

                        return Objects.equal(map.get("tenantcode"), tenantCode);
                    }
                });
        List<Map<String, String>> result = Lists.newArrayList(filterList);
        return (!result.isEmpty()) ? result.get(0) : null;
    }
}
