package com.horizon.third.adapter;

import java.util.Map;

import javax.servlet.http.HttpSession;

import com.horizon.third.SessionInfo;
import com.horizon.utils.HorizonPool;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.SessionUtil;

/**
 * session适配器
 * 
 * @author mwr
 *
 */
public class SessionAdapter extends WorkflowBaseAdapther implements SessionInfo {

    @Override
    public String getTenantCode(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_TENANT_CODE);
    }

    @Override
    public String getTenantName(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_TENANT_NAME);

    }

    @Override
    public String getDbIdentifierByTenantCode(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_TENANT_IDENTIFIER);
    }

    @Override
    public String getUserId(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_USER_ID);
    }

    @Override
    public String getUserName(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_USER_NAME);
    }

    @Override
    public String getDeptId(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_DEPT_ID);
    }

    @Override
    public String getDeptName(HttpSession session) {

        return getValue(session, HorizonPool.SESSION_DEPT_NAME);
    }

    public void setSessionInfo(HttpSession session, Map<String, String> mapUser) {

        for (Map.Entry<String, String> entry : mapUser.entrySet()) {
            SessionUtil.setAttribute(session, entry.getKey(), entry.getValue());
        }
        SessionUtil.setAttribute(session, "lang", HorizonPorps.getConfig("localeVal"));
    }

    protected String getValue(HttpSession session, String key) {

        return (String) SessionUtil.getAttribute(session, key);

    }
}
