package com.horizon.third.adapter;

import com.horizon.common.base.Function;
import com.horizon.common.base.Joiner;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.core.tree.TreeModel;
import com.horizon.third.SelectUser;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 人员选择框接口适配器
 *
 * @author mwr
 *
 */
public class SelectUserAdapter extends WorkflowBaseAdapther implements SelectUser {

    /**
     * 根据类型获得内存树
     *
     * @param type
     *            D：部门书；G：群组；P：岗位；R：角色
     * @return
     */
    @Override
    public TreeModel<OrgData> getOrgTree(String type) {
        return super.getOrgTree(type);
    }

    /**
     * 当点击人员选择框节点时，获取节点下的所有数据列表
     *
     * @param orgId
     *            节点ID
     * @param type
     *            节点类型
     * @param subUserLevel
     *            是否获取子节点人员
     * @return
     */
    @Override
    public List<OrgData> getChildren(String orgId, String type, Integer subUserLevel) {

        String orgType = Objects.equal("S", type) ? "D" : type;
        List<User> users = super.findUserByOrgId(orgType, orgId);
        List<OrgData> datas = this.transNodeData(users);
        List<OrgData> treeNodes = super.findChildrenData(orgType, orgId);
        if (treeNodes != null && !treeNodes.isEmpty()) {
            datas.addAll(treeNodes);
        }
        return datas;

    }

    /**
     * 根据条件检索组织机构（部门,群组,岗位）
     *
     * @param searchText 搜索内容
     * @param orgDatas 组织机构数据
     * @return
     */
    @Override
    public List<OrgData> getSearch(String searchText, List<OrgData> orgDatas) {
        List<OrgData> datas = Lists.newLinkedList();
        for (OrgData orgData : orgDatas) {
            String name = orgData.getName();
            String parentId = orgData.getParentId();//排除根部门|群组|岗位|角色
            if (StringUtil.hasValue(parentId) && StringUtil.hasValue(name) && name.contains(searchText)){
                datas.add(orgData);
            }
        }
        List<OrgData> result = Lists.newLinkedList();
        List<User> users = super.getUserLikeParam(searchText);
        for (User user : users) {
            OrgData data = new OrgData();
            data.setId(user.getId());
            data.setName(user.getUserName());
            data.setType(USER);
            data.setCode(user.getLoginName());
            result.add(data);
        }
        if (!datas.isEmpty()){
            result.addAll(datas);
        }
        return result;
    }

    /**
     * 通过用户ID获取获取用户信息，转换节点数据列表
     *
     * @param users
     *            人员列表
     */
    private List<OrgData> transNodeData(List<User> users) {
        final List<User> allUser = super.findAllUser();
        List<OrgData> result = new ArrayList<OrgData>();
        if (users != null && !users.isEmpty()) {
            for (User user : users) {
                int idx = allUser.indexOf(user);
                if(idx > -1){
                    OrgData data = new OrgData();
                    User u = allUser.get(idx);
                    String name = appendJobName(u);
                    data.setId(u.getId());
                    data.setName(name);
                    data.setType(USER);
                    data.setCode(u.getLoginName());
                    result.add(data);
                }
            }
        }
        return result;
    }



    /**
     * 用户名称追加职务信息
     *
     * @param user
     * @return
     */
    private String appendJobName(User user) {
        String name = user.getUserName();
        return Joiner.on("").join(name, user.getJobName());
    }
}
