package com.horizon.third.adapter;

import com.horizon.common.base.Preconditions;
import com.horizon.common.base.Predicate;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.third.RelationUsers;
import com.horizon.third.entity.OrgData;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

import java.util.Collection;
import java.util.List;

/**
 * 相对关系适配器
 *
 * @author mwr
 *
 */
public abstract class RelationAdapter extends WorkflowBaseAdapther implements RelationUsers {

    /**
     * 根据用户Id
     *
     * @param userId
     * @return
     */
    @Override
    protected String getDeptId(String userId) {

        List<String> list = Splitter.on(SUBJECTION_FIX).omitEmptyStrings().splitToList(userId);
        String id = list.get(0);
        String deptId = (list.size() == 2) ? list.get(1) : null;
        if (StringUtil.hasValue(deptId) && deptId.startsWith(DEPT_FIX)) {
            deptId = subPrefix(list.get(1));
        } else {
            User user = super.getUserById(subPrefix(id));
            deptId = user.getFirstDept();
        }
        return deptId;
    }

    protected String getPositionId(String userId) {

        List<String> list = Splitter.on(SUBJECTION_FIX).omitEmptyStrings().splitToList(userId);
        String id = list.get(0);
        String positionId = (list.size() == 2) ? list.get(1) : null;
        if (StringUtil.hasValue(positionId) && positionId.startsWith(POSITION_FIX)) {
            positionId = subPrefix(positionId);
        } else {
            positionId = this.getPositionByUserId(id);
        }
        return positionId;
    }

    /**
     * 根据给定的用户列表，过滤具有管理职务的用户列表
     *
     * @param parm
     *            管理职务类型
     * @param users
     *            用户列表
     * @return
     */
    protected List<User> filterManageUser(final String parm, final List<User> users) {
        final List<User> allUser = super.findAllUser();
        Collection<User> filterList = Collections2.filter(users, new Predicate<User>() {
            @Override
            public boolean apply(User user) {
                boolean isLeader = isLeaders(parm, user);
                if (!isLeader){
                    int idx = allUser.indexOf(user);
                    if (idx > -1) {
                        User u = allUser.get(idx);
                        isLeader = isLeaders(parm, u);
                    }
                }
                return isLeader;
            }
        });
        List<User> result = Lists.newArrayList();
        if (!filterList.isEmpty()) {
            result.addAll(filterList);
        }
        return result;
    }

    private boolean isLeaders(final String parm, User user) {
        boolean isTrue = false;
        String operType = user.getOperType();
        if (StringUtil.hasValue(operType)) {
            List<String> opers = Splitter.on(";").omitEmptyStrings().splitToList(operType);
            isTrue = opers.contains(parm);
        }
        return isTrue;
    }
    /**
     * 根据用户ID，获取所有岗位id
     *
     * @param userId
     *            用户ID
     * @return
     */
    private String getPositionByUserId(final String userId) {
        Preconditions.checkNotNull(userId, "请求的参数 userId 为 null ");
        String positionId = null;
        String id = super.subPrefix(userId);
        List<OrgData> nodeDatas = super.getOrgForUserByUserId(POSITION, id);
        if (nodeDatas != null && !nodeDatas.isEmpty()) {
            OrgData data = nodeDatas.get(0);
            positionId = data.getId();
        }
        return positionId;
    }

}
