package com.horizon.third.adapter;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.horizon.db.Access;
import com.horizon.db.DBConfigInfoHelper;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.third.Persistence;
import com.horizon.utils.StringUtil;

/**
 * 持久层实现类
 * 
 * @author yufang
 *
 */
@SuppressWarnings("unchecked")
public class PersistenceAdapter extends WorkflowBaseAdapther implements Persistence {

    @Override
    public String getUUID() {

        return Access.getUUID();
    }

    @Override
    public boolean executeUpdate(Map<String, List<Object>> mapSqlParameters) {

        return Access.executeUpdate(mapSqlParameters);
    }

    @Override
    public boolean executeUpdate(Map<String, List<Object>> mapSqlParameters, String dbIdentifier) {

        return Access.executeUpdate(mapSqlParameters, dbIdentifier);
    }

    @Override
    public boolean executeUpdate(String sql, List<? extends Object> lstParameters) {

        return Access.executeUpdate(sql, lstParameters);
    }

    @Override
    public boolean executeUpdate(String sql, List<? extends Object> lstParameters, String dbIdentifier) {

        return Access.executeUpdate(sql, lstParameters, dbIdentifier);
    }

    @Override
    public boolean executeMultiUpdate(Map<String, List<Object>> mapSqlParameters) {

        return Access.executeMultiUpdate(mapSqlParameters);
    }

    @Override
    public boolean executeMultiUpdate(Map<String, ? extends Collection<?>> mapSqlParameters, String dbIdentifier) {

        return Access.executeMultiUpdate(mapSqlParameters, dbIdentifier);
    }

    @Override
    public boolean saveClob(String tableName, String columnName, List<? extends Object> lstParameters) {

        return Access.saveClob(tableName, columnName, lstParameters);
    }

    @Override
    public boolean saveClob(String tableName, String columnName, List<? extends Object> lstParameters,
            String dbIdentifier) {

        return Access.saveClob(tableName, columnName, lstParameters, dbIdentifier);
    }

    @Override
    public boolean updateBlob(String tableName, String columnName, InputStream inputStream, String idValue) {

        return Access.updateBlob(tableName, columnName, inputStream, idValue);
    }

    @Override
    public boolean updateBlob(String tableName, String columnName, InputStream inputStream, String idValue,
            String dbIdentifier) {

        return Access.updateBlob(tableName, columnName, inputStream, idValue, dbIdentifier);
    }

    @Override
    public boolean saveObjectData(Map<String, Object> mapTableNameAndDataObjects) {

        return Access.saveObjectData(mapTableNameAndDataObjects);
    }

    @Override
    public boolean saveObjectData(Map<String, Object> mapTableNameAndDataObjects, String dbIdentifier) {

        return Access.saveObjectData(mapTableNameAndDataObjects, dbIdentifier);
    }

    @Override
    public List<Object> getSingleList(String sql, List<? extends Object> lstConditions) {

        return Access.getSingleList(sql, lstConditions);
    }

    @Override
    public List<Object> getSingleList(String sql, List<? extends Object> lstConditions, String dbIdentifier) {

        return Access.getSingleList(sql, lstConditions, dbIdentifier);
    }

    @Override
    public List<List<Object>> getMultiList(String sql, List<? extends Object> lstConditions) {

        return Access.getMultiList(sql, lstConditions);
    }

    @Override
    public List<List<Object>> getMultiList(String sql, List<? extends Object> lstConditions, String dbIdentifier) {

        return Access.getMultiList(sql, lstConditions, dbIdentifier);
    }

    @Override
    public List<List<Object>> getPagingList(String sql, List<? extends Object> lstConditions, int iPageNum,
            int iPageSize) {

        return Access.getPagingList(sql, lstConditions, iPageNum, iPageSize);
    }

    @Override
    public List<List<Object>> getPagingList(String sql, List<? extends Object> lstConditions, int iPageNum,
            int iPageSize, String dbIdentifier) {

        return Access.getPagingList(sql, lstConditions, iPageNum, iPageSize, dbIdentifier);
    }

    @Override
    public Map<String, Object> getSingleMap(String sql, List<? extends Object> lstConditions) {

        return Access.getSingleMap(sql, lstConditions);
    }

    @Override
    public Map<String, Object> getSingleMap(String sql, List<? extends Object> lstConditions, String dbIdentifier) {

        return Access.getSingleMap(sql, lstConditions, dbIdentifier);
    }

    @Override
    public List<Map<String, Object>> getMultiMap(String sql, List<? extends Object> lstConditions) {

        return Access.getMultiMap(sql, lstConditions);
    }

    @Override
    public List<Map<String, Object>> getMultiMap(String sql, List<? extends Object> lstConditions,
            String dbIdentifier) {

        return Access.getMultiMap(sql, lstConditions, dbIdentifier);
    }

    @Override
    public List<Map<String, Object>> getPagingMap(String sql, List<? extends Object> lstConditions, int iPageNum,
            int iPageSize) {

        return Access.getPagingMap(sql, lstConditions, iPageNum, iPageSize);
    }

    @Override
    public List<Map<String, Object>> getPagingMap(String sql, List<? extends Object> lstConditions, int iPageNum,
            int iPageSize, String dbIdentifier) {

        return Access.getPagingMap(sql, lstConditions, iPageNum, iPageSize, dbIdentifier);
    }

    @Override
    public <T> T getSingleObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass) {

        return (T) Access.getSingleObject(sql, lstConditions, dataObjectClass);
    }

    @Override
    public <T> T getSingleObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass,
            String dbIdentifier) {

        return (T) Access.getSingleObject(sql, lstConditions, dataObjectClass, dbIdentifier);
    }

    @Override
    public <T> List<T> getMultiObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass) {

        return Access.getMultiObject(sql, lstConditions, dataObjectClass);
    }

    @Override
    public <T> List<T> getMultiObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass,
            String dbIdentifier) {

        return Access.getMultiObject(sql, lstConditions, dataObjectClass, dbIdentifier);
    }

    @Override
    public <T> List<T> getPagingObject(String sql, List<? extends Object> lstConditions, int iPageNum, int iPageSize,
            Class<T> dataObjectClass) {

        return Access.getPagingObject(sql, lstConditions, iPageNum, iPageSize, dataObjectClass);
    }

    @Override
    public <T> List<T> getPagingObject(String sql, List<? extends Object> lstConditions, int iPageNum, int iPageSize,
            Class<T> dataObjectClass, String dbIdentifier) {

        return Access.getPagingObject(sql, lstConditions, iPageNum, iPageSize, dataObjectClass, dbIdentifier);
    }

    @Override
    public int getRsCount(String sql, List<? extends Object> lstConditions) {

        return Access.getRsCount(sql, lstConditions);
    }

    @Override
    public int getRsCount(String sql, List<? extends Object> lstConditions, String dbIdentifier) {

        return Access.getRsCount(sql, lstConditions, dbIdentifier);
    }

    @Override
    public String getClobContent(String tableName, String fieldName, String condition) {

        return Access.getClobContent(tableName, fieldName, condition);
    }

    @Override
    public String getClobContent(String tableName, String fieldName, String condition, String dbIdentifier) {

        return Access.getClobContent(tableName, fieldName, condition, dbIdentifier);
    }

    @Override
    public byte[] getBlobContentBytes(String tableName, String fieldName, String condition) {

        return Access.getBlobContentBytes(tableName, fieldName, condition);
    }

    @Override
    public byte[] getBlobContentBytes(String tableName, String fieldName, String condition, String dbIdentifier) {

        return Access.getBlobContentBytes(tableName, fieldName, condition, dbIdentifier);
    }

    @Override
    public Map<String, Object> getTableColumnMsg(String tableName) {

        return Access.getTableColumnMsg(tableName);
    }

    @Override
    public Map<String, Object> getTableColumnMsg(String tableName, boolean isToLowerCase) {

        return Access.getTableColumnMsg(tableName, isToLowerCase);
    }

    @Override
    public Map<String, Object> getTableColumnMsg(String tableName, boolean isToLowerCase, String dbIdentifier) {

        return Access.getTableColumnMsg(tableName, isToLowerCase, dbIdentifier);
    }

    @Override
    public List<Object> getTableNames() {

        return Access.getTableNames();
    }

    @Override
    public List<Object> getTableNames(String dbIdentifier) {

        return Access.getTableNames(dbIdentifier);
    }

    @Override
    public String getDbType(String dbIdentifier) {

        String dbtype = null;
        try {
            dbtype = DBConfigInfoHelper.getDatabaseType(dbIdentifier);
        } catch (InvalidIdentifierException e) {
            e.printStackTrace();
        }

        return dbtype;

    }

    @Override
    public String getDefaultDbType() {

        String defaultDbIdentifier = getDefaultDatabaseIdentifier();
        return getDbType(defaultDbIdentifier);
    }

    @Override
    public boolean validateIdentifier(String dbIdentifier) {

        boolean isTrue = false;
        if (StringUtil.hasValue(dbIdentifier)) {
            isTrue = (getDbType(dbIdentifier) != null);
        }
        return isTrue;

    }

    @Override
    public String getDefaultDatabaseIdentifier() {

        return DBConfigInfoHelper.getDefaultDatabaseIdentifier();
    }

}
