package com.horizon.third.adapter;

import com.horizon.common.base.Objects;
import com.horizon.third.Identity;
import com.horizon.third.entity.User;
import com.horizon.utils.StringUtil;

/**
 * 身份认证接口适配器
 * 
 * @author mwr
 *
 */
public class IdentityAdapter extends WorkflowBaseAdapther implements Identity {


    /**
     * 验证用户是否存在
     *
     * @param loginName
     *            登陆名
     * @param dbIdentifier
     *            数据源标识
     * @return true:存在 false：不存在
     */
    @Override
    public boolean checkUserExist(String loginName, String dbIdentifier) {

        if (!StringUtil.hasValue(loginName)) {
            return false;
        }
        User users = super.getUserByLoginName(loginName);
        return Objects.equal(users.getLoginName(), loginName);
    }

    /**
     * 验证用户密码的正确性
     *
     * @param loginName
     *            登陆名
     * @param password
     *            密码（明文）
     * @param dbIdentifier
     *            数据源标识
     * @return true：符合 false:不符合
     */
    @Override
    public boolean checkUserPass(String loginName, String password, String dbIdentifier) {

        if (!StringUtil.hasValue(password)) {
            return false;
        }
        User user = super.getUserByLoginName(loginName);
        if (user != null){
            return Objects.equal(user.getPasswd(), password);
        }
        return false;
    }

}
