package com.horizon.third.adapter;

import java.util.*;

import com.horizon.third.Form;
import com.horizon.third.Persistence;
import com.horizon.third.ThirdAdapterFactory;

/**
 * 表单接口适配器
 * 
 * @author mwr
 *
 */
public class FormAdapter extends WorkflowBaseAdapther implements Form {

	Persistence access = ThirdAdapterFactory.getPersistenceInstance();
	/**
	 * 非人员相关字符串的连接符号
	 */
	private static final String SPLITCHAR = ";";
	// 获取主表单域
	private static final String SQLFORMFIELD = "SELECT B.FORMID AS ID,A.FIELDNAME,A.FIELD_NAME,A.FIELD_ORDER,A.INPUTTYPE,A.DEFAULTVALUE "
			+ "FROM TF_HORIZON_TABLE_FIELD A,TFR_HORIZON_FIELD_FORM B WHERE A.ID = B.FIELDID  AND B.FORMID ";
	// 获取子表单字段，字段跟主表id关联
	private static final String SQLSUBFORMFIELD = "SELECT C.FORMID AS ID,A.FIELDNAME,A.FIELD_NAME,A.FIELD_ORDER,A.INPUTTYPE,A.DEFAULTVALUE "
			+ "FROM TF_HORIZON_TABLE_FIELD A,TFR_HORIZON_FIELD_FORM B,TFR_HORIZON_FORM_SUB C "
			+ "WHERE A.ID = B.FIELDID  AND B.FORMID = C.SUBFORMID AND C.FORMID ";
	// 获取主表单按钮
	private static final String SQLFORMBUTTON = "SELECT A.FORMID,A.ID,A.BUTTON_NAME,A.BUTTON_ORDER FROM TF_HORIZON_FORM_BUTTON A WHERE A.FORMID ";
	// 获取子表单按钮
	private static final String SQLSUBFORMBUTTON = "SELECT C.FORMID,A.ID,A.BUTTON_NAME,A.BUTTON_ORDER FROM TF_HORIZON_FORM_BUTTON A,TFR_HORIZON_FORM_SUB C "
			+ "WHERE A.FORMID = C.SUBFORMID AND C.FORMID ";
	// 获取定制普通表单
	private static final String SQLCOMMONFORM = "SELECT A.ID,A.FORM_NAME,B.TABLENAME,C.APP_NAME,C.ID FROM TF_HORIZON_FORM A "
			+ " INNER JOIN TF_HORIZON_TABLE B ON A.ISFLOW=1 AND A.TABLEID=B.ID "
			+ " LEFT JOIN TSR_HORIZON_MODULE_DESIGN D ON D.TYPEID = B.ID "
			+ " LEFT JOIN TS_HORIZON_MODULE C ON C.ID = D.APPID " + " ORDER BY C.ID";
	// 获取定制图形表单
	private static final String SQLGRAPHICFORM = "SELECT A.ID,A.FLOWFORMNAME,A.TABLENAME ,C.APP_NAME,C.ID AS APP_ID FROM TF_HORIZON_FORM_GRAPHICS A "
			+ "LEFT JOIN TSR_HORIZON_MODULE_DESIGN D ON D.TYPEID = A.TABLEID "
			+ "LEFT JOIN TS_HORIZON_MODULE C ON C.ID = D.APPID " + "WHERE A.ISFLOW=1 " + " ORDER BY C.ID";
	// 静态化定制表单
	private static final String SQLSTATICCOMMONFORM = "SELECT E.ID,E.STATIC_NAME,B.TABLENAME,C.APP_NAME,C.ID,A.ID FROM TF_HORIZON_FORM_STATIC E,TF_HORIZON_FORM A "
			+ " INNER JOIN TF_HORIZON_TABLE B ON A.ISFLOW=1 AND A.TABLEID=B.ID "
			+ " LEFT JOIN TSR_HORIZON_MODULE_DESIGN D ON D.TYPEID = B.ID "
			+ " LEFT JOIN TS_HORIZON_MODULE C ON C.ID = D.APPID " + " WHERE A.ID = E.FORMID " + " ORDER BY C.ID";
	// 静态化图形表单
	private static final String SQLSTATICGRAPHICFORM = "SELECT E.ID,E.STATIC_NAME,A.TABLENAME,C.APP_NAME,C.ID AS APP_ID,A.ID FROM TF_HORIZON_FORM_STATIC E,TF_HORIZON_FORM_GRAPHICS A,"
			+ "TS_HORIZON_MODULE C, TSR_HORIZON_MODULE_DESIGN D WHERE A.ISFLOW=1 AND C.ID = D.APPID AND D.TYPEID = A.TABLEID"
			+ " AND E.FORMID = A.ID " + " ORDER BY C.ID";

	/**
	 * 获得定制表单信息，包括普通表单和图形表单
	 * 定制工具选择表单时,获取表单列表,在xmlflow.getFormList.jsp中使用
	 * @param para
	 * @param identifier
	 *            数据源标识
	 * @return
	 */
	public String getFormAllInfo(List<String> para, String identifier) {
		// 普通表单
		String sqlCommon = "SELECT A.ID,A.FORM_NAME,B.TABLENAME FROM TF_HORIZON_FORM A, TF_HORIZON_TABLE B WHERE A.TABLEID=B.ID AND A.ID ";
		// 图形表单
		String sqlGraphic = "SELECT A.ID,A.FLOWFORMNAME,A.TABLENAME FROM TF_HORIZON_FORM_GRAPHICS A WHERE A.ID ";
		StringBuilder sql = new StringBuilder();
		List<String> pp = new ArrayList<String>();

		String[] tmpArr = para.get(0).split(SPLITCHAR);
		int size = tmpArr.length;
		if (size == 0)
			return "";
		for (int i = 0; i < size; i++) {
			sql.append(",?");
			pp.add(tmpArr[i]);
		}
		if (size == 1) {
			sql.deleteCharAt(0).insert(0, "=");
		} else {
			sql.deleteCharAt(0).insert(0, " IN(").append(")");
		}

		String strPara = sql.toString();
		sql.delete(0, sql.length());
		sql.append(sqlGraphic).append(strPara).append(" UNION ").append(sqlCommon).append(strPara);

		pp.addAll(pp);
		List<List<Object>> result = access.getMultiList(sql.toString(), pp, identifier);
		if (result == null || result.isEmpty()) {
			return "";
		}

		StringBuilder back = new StringBuilder();
		for (int i = 0, n = result.size(); i < n; i++) {
			List<Object> tmpList = result.get(i);
			back.append("|").append((String) tmpList.get(1)).append("=").append((String) tmpList.get(0)).append("=")
					.append((String) tmpList.get(2));
		}

		back.deleteCharAt(0).insert(0, getFormInfoByID(para, identifier) + "^");
		return back.toString();
	}


	/**
	 * 根据表单Ids,获得表单对应的字段信息和操作信息
	 * 流程定义加载时
	 * @param ids    表单Id数组
	 * @param identifier
	 *            数据源标识
	 * @return
	 *         formid~actionid=name|actionid=name,formid~actionid=name|actionid=name
	 *         formid~fieldid=name|fieldid=name,formid~fieldid=name|fieldid=name
	 */
	@Override
	public String getFormInfoByID(List<String> ids, String identifier) {
		if (ids == null || ids.isEmpty()) {
			return "^";
		}
		try {
			StringBuilder sb = new StringBuilder();
			List<Object> para = new ArrayList<Object>();
			//字段
			Map<String, Object> fieldMap = new LinkedHashMap<String, Object>();
			//操作
			Map<String, Object> actionMap = new LinkedHashMap<String, Object>();
			int size = ids.size();
			for (int i = 0, n = size; i < n; i++) {
				if ((ids.get(i)).trim().length() == 0) {
					continue;
				}
				sb.append(",?");
				para.add(ids.get(i));

				fieldMap.put((String) ids.get(i), new LinkedHashMap<String, Object>());
				actionMap.put((String) ids.get(i), new LinkedHashMap<String, Object>());
			}
			// sql处理
			if (para == null || para.isEmpty()) {
				return "^";
			}
			sb.deleteCharAt(0);
			if (para.size() == 1) {
				sb.insert(0, "=");
			} else {
				sb.insert(0, "in(").append(")");
			}
			String idsql = sb.toString();
			para.addAll(para);// 两个sqlunion条件一样，需要拷贝

			// 字段信息,包含子表单字段信息
			String sqlField = "SELECT * FROM (" + SQLFORMFIELD + idsql + " UNION " + SQLSUBFORMFIELD + idsql
					+ ") Z ORDER BY FIELD_ORDER";
			List<List<Object>> result = access.getMultiList(sqlField, para, identifier);
			if (result != null && !result.isEmpty()) {
				for (int i = 0, n = result.size(); i < n; i++) {
					List<Object> tmpLst = result.get(i);
					String formID = (String) tmpLst.get(0);
					Object inputstr = tmpLst.get(4);
					// 忽略没有录入类型的字段
					if (inputstr == null || "".equals(inputstr)) {
						continue;
					}
					@SuppressWarnings("unchecked")
					Map<String, Object> mapFiled = (LinkedHashMap<String, Object>) fieldMap.get(formID);
					mapFiled.put(String.valueOf(tmpLst.get(1)), String.valueOf(tmpLst.get(2)));
				}
			}

			// 操作信息
			String sqlButton = "SELECT * FROM (" + SQLFORMBUTTON + idsql + " UNION " + SQLSUBFORMBUTTON + idsql
					+ ") Z ORDER BY BUTTON_ORDER";
			List<List<Object>> resultButton = access.getMultiList(sqlButton, para, identifier);
			if (resultButton != null && !resultButton.isEmpty()) {
				for (int i = 0, n = resultButton.size(); i < n; i++) {
					List<Object> tmpLst = resultButton.get(i);
					String formID = (String) tmpLst.get(0);
					@SuppressWarnings("unchecked")
					Map<String, Object> mapAction = (LinkedHashMap<String, Object>) actionMap.get(formID);
					mapAction.put(String.valueOf(tmpLst.get(1)), tmpLst.get(2));
				}
			}

			// 准备返回结果
			sb.delete(0, sb.length());
			for (Iterator<String> it = actionMap.keySet().iterator(); it.hasNext();) {
				String fieldName = it.next();
				sb.append(",").append(fieldName).append("~");
				@SuppressWarnings("unchecked")
				Map<String, Object> tmpMap = (LinkedHashMap<String, Object>) actionMap.get(fieldName);
				for (Iterator<String> it1 = tmpMap.keySet().iterator(); it1.hasNext();) {
					String id = it1.next();
					sb.append(id).append("=").append(tmpMap.get(id)).append(SPLITCHAR);
				}
			}
			if (sb.length() > 0) {
				sb.deleteCharAt(0);
			}
			sb.append("^");
			for (Iterator<String> it = fieldMap.keySet().iterator(); it.hasNext();) {
				String fieldName = it.next();
				sb.append(fieldName).append("~");
				@SuppressWarnings("unchecked")
				Map<String, Object> tmpMap = (LinkedHashMap<String, Object>) fieldMap.get(fieldName);
				for (Iterator<String> it1 = tmpMap.keySet().iterator(); it1.hasNext();) {
					String id = it1.next();
					sb.append(id.toUpperCase()).append("=").append(tmpMap.get(id)).append(SPLITCHAR);
				}
				sb.append(",");
			}
			return (",").equals(sb.substring(sb.length() - 1)) ? sb.substring(0, sb.length() - 1) : sb.toString();
		} catch (Exception e) {
			return "^";
		}
	}

	/**
	 * 获取定制表单对应的字段权限设置属性
	 *
	 * @param formid
	 *            表单Id
	 * @param identifier
	 *            数据源标识
	 * @return
	 */
	public List<Map<String, Object>> getFormFieldsAuthByFormId(String formid, String identifier) {
		String sql = "select * from TF_HORIZON_WORKFORM_FIELDAUTH t where formid=? order by Auth_NAME";
		List<String> para = new ArrayList<String>(1);
		para.add(formid);
		return access.getMultiMap(sql, para, identifier);
	}
	/**
	 * 获取指定formid的表单包含的字段信息
	 * @param formid
	 * @param identifier
	 * @return
	 */
	public List<Map<String, Object>> getFieldsByFormID(String formid, String identifier){
		// 字段信息,包含子表单字段信息
		String sqlField = "SELECT * FROM (" + SQLFORMFIELD +  "=? UNION "
				+ SQLSUBFORMFIELD + "=?) Z ORDER BY FIELD_ORDER";
		List<Object> para = new ArrayList<Object>();
		para.add(formid);
		para.add(formid);
		return access.getMultiMap(sqlField, para, identifier);
	}

//======================================================================

	/**
	 * 获取所有表单信息
	 *
	 * @param identifier
	 *            数据源标识
	 * @return List[0]: 类型是List,普通表单信息 List[1]: 类型是List,图形表单信息
	 */

	public List<List<List<Object>>> getFormList(String identifier) {
		List<List<List<Object>>> result = new ArrayList<List<List<Object>>>(2);
		try {
			List<List<Object>> html = access.getMultiList(SQLCOMMONFORM, null, identifier);
			List<List<Object>> map = access.getMultiList(SQLGRAPHICFORM, null, identifier);
			result.add(html);
			result.add(map);
		} catch (Exception e) {
			result.add(null);
			result.add(null);
		}
		return result;
	}

	/**
	 * 获取所有静态化表单信息
	 *
	 * @param identifier
	 *            数据源标识
	 * @return List[0]: 类型是List,普通表单信息 List[1]: 类型是List,图形表单信息
	 */
	public List<List<List<Object>>> getFormsStaticList(String identifier) {
		List<List<List<Object>>> result = new ArrayList<List<List<Object>>>(2);
		List<List<Object>> html = access.getMultiList(SQLSTATICCOMMONFORM, null, identifier);
		List<List<Object>> map = access.getMultiList(SQLSTATICGRAPHICFORM, null, identifier);
		result.add(html);
		result.add(map);
		return result;
	}



}
