package com.horizon.third.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.common.base.Objects;
import com.horizon.third.Authority;
import com.horizon.third.Persistence;
import com.horizon.third.init.WorkflowAdapterInit;

/**
 * 流程管理适配器
 * 
 * @author mwr
 *
 */
public class FlowManageAdapter extends WorkflowBaseAdapther implements Authority {

    private static final Logger LOGGER = LoggerFactory.getLogger(FlowManageAdapter.class);

    private static final String SELECT_FLOWS = "SELECT A.FLOWID FROM TW_HZ_FLOW_DEF"
            + " A WHERE A.VERSION=(SELECT MAX(VERSION) FROM TW_HZ_FLOW_DEF WHERE FLOWID=A.FLOWID)";

    /*
     * (non-Javadoc)
     * 
     * @see com.horizon.third.Authority#getManager(java.lang.String)
     */
    @Override
    public String getManager(String flowId) {

        LOGGER.info("流程 {} 默认管理员为 admin ", flowId);
        return "admin";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.horizon.third.Authority#isStart(java.lang.String,
     * java.lang.String)
     */
    @Override
    public boolean isStart(String flowId, String userId) {

        LOGGER.info("用户 {} 拥有启动流程 {},默认返回 true ", userId, flowId);
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.horizon.third.Authority#isManager(java.lang.String,
     * java.lang.String)
     */
    @Override
    public boolean isManager(String flowId, String userId) {

        LOGGER.info("流程 {} 管理员 admin ", flowId);
        return Objects.equal("admin", userId);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.horizon.third.Authority#getFlowManageList(java.lang.String,
     * java.lang.String)
     */
    @Override
    public List<String> getFlowManageList(String userid, String identifier) {

        return getFlowDesignList(userid, identifier);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.horizon.third.Authority#getFlowDesignList(java.lang.String,
     * java.lang.String)
     */
    @Override
    public List<String> getFlowDesignList(String userId, String dbIdentifier) {

        Persistence access = (Persistence) WorkflowAdapterInit.getWorkflowAdapthers("access");
        List<List<Object>> lst = access.getMultiList(SELECT_FLOWS, null, dbIdentifier);
        List<String> lstResult = new ArrayList<String>();
        if (lst != null && !lst.isEmpty()) {
            for (List<Object> l : lst) {
                lstResult.add((String) l.get(0));
            }
        }
        return lstResult;
    }

    /**
     * 获得流程启动权限列表
     * 
     * @param userid
     *            用户Id
     * @param identifier
     *            数据源标识
     * @return 具有启动权限的流程Id
     */
    public List<String> getFlowStartList(String userid, String identifier) {

        Persistence access = (Persistence) WorkflowAdapterInit.getWorkflowAdapthers("access");
        List<List<Object>> lst = access.getMultiList(SELECT_FLOWS, null, identifier);

        List<String> lstResult = new ArrayList<String>();
        if (lst != null && !lst.isEmpty()) {
            for (List<Object> lstObject : lst) {

                lstResult.add(String.valueOf(lstObject.get(0)));
            }
        }
        return lstResult;

    }

    @Override
    public void authInit(String userId, String dataid, String resourceType, Map<String, List<Object>> saveMap,
            String dbIdentifier) {

        // TODO Auto-generated method stub
        
    }

    @Override
    public void releaseBizPermission(String[] dataids, Map<String, List<List<Object>>> saveMap) {

        // TODO Auto-generated method stub
        
    }

    @Override
    public boolean validateOperatorTenant(String userId, String tenantCode, String dbIdentifier) {

        // TODO Auto-generated method stub
        return false;
    }

}
