package com.horizon.third;

import java.util.Date;

/**
 * 工作日历接口
 * 
 * @author mwr
 *
 */
public interface WorkCalendar {

    /**
     * 获取给定两个日期之间的工作日 (date1 > date2 )
     * <p>
     * 时间格式：yyyy-MM-dd HH:mm:ss
     * </p>
     * 
     * @param date1
     *            开始时间
     * @param date2
     *            结束时间
     * @param datetype
     *            0:工作日,1:自然天,2:小时,3:分钟
     * @param identifier
     *            数据源标识符
     * @return
     */
    public int getWorkdaysFromTwoDate(Date date1, Date date2, int datetype, String identifier);

    /**
     * 获取给定两个日期之间的工作日 (date1 > date2 )
     * <p>
     * 时间格式：yyyy-MM-dd HH:mm:ss
     * </p>
     * 
     * @param date1
     *            开始时间
     * @param date2
     *            结束时间
     * @param datetype
     *            0:工作日,1:自然天,2:小时,3:分钟
     * @param identifier
     *            数据源标识符
     * @return
     */
    public int getWorkdaysFromTwoDate(String date1, String date2, int datetype, String identifier);

    /**
     * 根据日期date获取days后的日期(按照datetype指定方式)
     * 
     * @param date
     *            (2015-03-20)
     * @param datetype
     *            =0工作日 1自然日
     * @param days
     *            2
     * @return 2015-03-24 2015-03-22
     */

    public Date getDateAfter(Date date, int datetype, int days, String identifier);
}
