package com.horizon.third;

import java.util.List;
import java.util.Map;

public interface TenantInfo {

    /**
     * 从新加载租户信息
     */
    public void reload();

    /**
     * 获得所有系统空间的租户信息 （只从tw_hz_tenant表中查找）
     * 
     * @return
     */
    public List<Map<String, String>> getTenants();

    /**
     * 根据租户标识获取租户名称
     * 
     * @param tenantCode
     * @return
     */
    public Map<String, String> getTenantName(String tenantCode);
}
