package com.horizon.third;

import java.util.Map;

import javax.servlet.http.HttpSession;

/**
 * session接口，用于JSP页面，或者设计获取当前用户信息
 * 
 * @author mwr
 *
 */
public interface SessionInfo {

    /**
     * 获得当前用户的租户标识
     * 
     * @param session
     * @return
     */
    String getTenantCode(HttpSession session);

    /**
     * 获得当前用户的租户名称
     * 
     * @param session
     * @return
     */
    String getTenantName(HttpSession session);

    /**
     * 获得当前用户的租户数据源标识符
     * 
     * @param session
     * @return
     */
    String getDbIdentifierByTenantCode(HttpSession session);

    /**
     * 获得当前登录用的Id
     * 
     * @param session
     * @return
     */
    String getUserId(HttpSession session);

    /**
     * 获得当前登录用的名称
     * 
     * @param session
     * @return
     */
    String getUserName(HttpSession session);

    /**
     * 获得当前登录用的部门ID
     * 
     * @param session
     * @return
     */
    String getDeptId(HttpSession session);

    /**
     * 获得当前登录用的部门名称
     * 
     * @param session
     * @return
     */
    String getDeptName(HttpSession session);

    /**
     * 登录成功后将用户信息设置到session中
     * 
     * <pre>
     * <div style="border: dashed 1px gray">
     *   Map<String, SessionValueItem> m = new HashMap<String, SessionValueItem>();
     *   long timeMillis = System.currentTimeMillis();
     *   m.put(HorizonPool.SESSION_USER_ID,           newValueItem(mapUser.get("user_id"), timeMillis));
     *   m.put(HorizonPool.SESSION_USER_NAME,         newValueItem(mapUser.get("user_name"), timeMillis));
     *   m.put(HorizonPool.SESSION_DEPT_ID,           newValueItem(mapUser.get("dept_id"), timeMillis));
     *   m.put(HorizonPool.SESSION_DEPT_NAME,         newValueItem(mapUser.get("dept_name"), timeMillis));
     *   m.put(HorizonPool.SESSION_TENANT_CODE,       newValueItem(mapUser.get("tenantcode"), timeMillis));
     *   m.put(HorizonPool.SESSION_TENANT_NAME,       newValueItem(mapUser.get("tenantname"), timeMillis));
     *   m.put(HorizonPool.SESSION_TENANT_IDENTIFIER, newValueItem(mapUser.get("dbidentifierflag"), timeMillis));
     *   String sessionId = session.getId();
     *   session.setAttribute(sessionId, m);
     * </div>
     * </pre>
     * 
     * @param session
     * @param mapUser
     */
    void setSessionInfo(HttpSession session, Map<String, String> mapUser);
}
