package com.horizon.third;

import com.horizon.core.tree.TreeModel;
import com.horizon.third.entity.OrgData;

import java.util.List;

/**
 * 人员选择框接口
 *
 * @author mwr
 *
 */
public interface SelectUser {
    /**
     * 根据类型获得内存树
     *
     * @param type
     *            D：部门书；G：群组；P：岗位；R：角色
     * @return
     */
    @Deprecated
    TreeModel<OrgData> getOrgTree(String type);


    /**
     * 当点击人员选择框节点时，获取节点下的所有数据列表
     *
     * @param orgId
     *            节点ID
     * @param type
     *            节点类型
     * @param subUserLevel
     *            子节点层级
     * @return
     */
    List<OrgData> getChildren(String orgId, String type, Integer subUserLevel);


    /**
     * 人员选择框搜索
     *
     * @param searchText
     *            检索条件
     * @return
     */
    List<OrgData> getSearch(String searchText, List<OrgData> datas);


}
