package com.horizon.third;


import com.horizon.core.tree.TreeModel;
import com.horizon.third.entity.OrgData;

import java.util.List;
import java.util.Map;

/**
 * 组织机构接口
 *
 * @author mwr
 *
 */
public interface Organization extends OrgDesigner {

    /**
     * 去掉orgs中不存在的组织机构id
     *
     * @param orgs
     *            组织机构id字符串
     * @return
     */
    String removeNotExitsOrg(String orgs, String identifier);

    /**
     * 根据给定的部门id获取部门下的用户
     *
     * @param deptId
     *            多个部门id以";"隔开
     * @param isHaveSubDept
     *            是否含有子部门;
     *            <p>
     *            true:含有子部门;
     *            <p>
     *            false：不含子部门
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getAllUserFromDept(String deptId, boolean isHaveSubDept, String identifier);

    /**
     * 根据给定的部门id获取部门下的用户
     *
     * @param deptId
     *            多个部门id以";"隔开
     * @param isHaveSubDept
     *            是否含有子部门;
     *            <p>
     *            true:含有子部门;
     *            <p>
     *            false：不含子部门
     * @param allNodes
     *            含有子部门;
     *            <p>
     *            true:含有直接子部门;
     *            <p>
     *            false：全部子部门
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getAllUserFromDept(String deptId, boolean isHaveSubDept, boolean allNodes, String identifier);

    /**
     * 根据给定的群组id获取群组下的用户
     *
     * @param groupId
     *            ：多个部门id以";"隔开
     * @param identifier
     * @return 用户id组成的字符串，多个以";"隔开
     */
    String getAllUserFromGroup(String groupId, String identifier);

    /**
     * 根据给定的岗位id获取岗位下的用户
     *
     * @param positionId
     *            ：多个岗位id以";"隔开
     * @param identifier
     * @return 用户id组成的字符串，多个以";"隔开
     */
    String getAllUserFromPosition(String positionId, String identifier);

    /**
     * 根据组织机构中的人员之间的关系获取人员(比如根据userid来获取直接领导,下属)
     *
     * @param para
     *            <p>
     *            key = userID value = String 流程当前办理用户id
     *            <p>
     *            key = creator value = String 流程创建用户id
     *            <p>
     *            key = done value = String[] 目标节点历史办理人id
     *            <p>
     *            key = base value = int[] 基准 0=无,1=指定节点办理人,2=创建者,3=当前执行人curUser
     *            <p>
     *            key = tarRange value = String[] 相对岗位
     *            <p>
     *            key = gathertype value = int[] 交集并集默认2并集
     *            <p>
     *            key = relation value = String[] 关系编号
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getRelationUser(Map<String, Object> para, String identifier);

    /**
     * 获取给定用户的所有相关id
     *
     * @param userId
     *            用户ID
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getAllUserids(String userId, String identifier);

    /**
     * @modifier chengll 2018年1月30日 根据用户ID获得用户所属的组织机构列表(部门,群组,岗位,角色)
     *
     * @param userId
     *            用户ID
     * @return
     */
    List<OrgData> getAllOrgsByUserId(String userId);




    /**
     * 根据userId获取用户相关信息
     *
     * @param userId 用户ID
     * @param identifier 数据源标识符
     * @return
     */
    Map<String, String> getUserById(String userId, String identifier);

    /**
     * 获取给定部门deptid的下级子部门id
     *
     * @param deptId
     *            部门Id
     * @param identifier
     *            租户标识
     * @return
     */
    String getSubDeptIdById(String deptId, String identifier);

    /**
     * 获取指定userid所在的直属部门id
     *
     * @param userId
     *            用户ID
     * @param identifier
     *            租户标识
     * @return
     */
    String getDeptIdByUserid(String userId, String identifier);

    /**
     * 获取指定userid所在的直属群组id
     *
     * @param userId
     *            用户ID
     * @param identifier
     *            租户标识
     * @return
     */
    String getGroupIdByUserid(String userId, String identifier);

    /**
     * 获取指定userid所在的直属岗位id
     *
     * @param userId
     *            用户ID
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getPositionIdByUserid(String userId, String identifier);

    /**
     * 获取指定userid所在的直属角色id
     *
     * @param userId
     *            用户ID
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getRoleIdByUserid(String userId, String identifier);

    /**
     * 获取指定id的中文名称,id可能是任何组织类型
     *
     * @param id
     * @param identifier
     *            数据源标识符
     * @return
     */
    String getNameByIds(String id, String identifier);

    /**
     * 根据登录名获得用户信息
     *
     * @param loginName
     * @param identifier
     *            数据源标识符
     * @return
     */
    Map<String, String> getUserByLoginName(String loginName, String identifier);

    /**
     * 判断是否开启权限过滤树
     *
     * @param tree 组织机构树
     *
     * @param auth 权限开关
     *
     * @return
     */
    TreeModel<OrgData> getTreeNodeByAuth(TreeModel<OrgData> tree, Boolean auth);

    /**
     * 判断是否开启权限过滤树
     *
     * @param orgdatas 组织机构数据
     *
     * @param auth 权限开关
     *
     * @return
     */
    List<OrgData> getTreeNodeByAuth(List<OrgData> orgdatas, Boolean auth);

    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @param isAllChild
     * @return
     */
     List<OrgData> findChildrenData(String type, String orgId, boolean isAllChild);
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @param orgId 组织机构id
     * @return
     */
     List<OrgData> findChildrenData(String type, String orgId);
    /**
     * 根据组织机构的类型和id查找对应给组织机构下的用户
     * @param type type D:部门;G:群组;P:岗位;R:角色
     * @return
     */
     OrgData getRootNode(String type);

    /**
     * 根据组织机构的类型和id查找对应给组织机构数据
     * @param type 组织机构类型
     * @param orgId 组织机构ID
     * @return
     */
    OrgData getOrgDataById(String type, String orgId);

    /**
     * 根据deptid以及职务类型查询指定的用户id
     * @param deptid
     * @param type 职务类型
     * @param identifier
     * @return
     */
    String getDeptSpecialUser(String deptid, String type, String identifier);
}
