package com.horizon.third;

import java.util.List;
import java.util.Map;

/**
 * 设计器用到的组织机构接口
 * 
 * @author liys
 * @since 20160415
 * @version 7.2.2
 */
public interface OrgDesigner {

    /**
     * 根据用户Id获得用户信息 设计器用到的方法
     * 
     * @param userIds
     * @return List<Map> map中的key: id, name
     * 
     */
    public List<Map<String, String>> getUserByIDs(String[] userIds, String dbIdentifier);

    /**
     * 根据部门Id获得部门信息 设计器用到的方法
     * 
     * @param deptIds
     *            部门Id数组
     * @return List<Map> map中的key: id,dept_name
     */
    public List<Map<String, String>> getDeptsByIDs(String[] deptIds, String dbIdentifier);

    /**
     * 根据群组Id获得群组信息 设计器用到的方法
     * 
     * @param groupIds
     *            群组Id数组
     * @return List<Map> map中的key: id,group_name
     */
    public List<Map<String, String>> getGroupByIDs(String[] groupIds, String dbIdentifier);

    /**
     * 根据岗位Id获得岗位信息 设计器用到的方法
     * 
     * @param positionIds
     * @return List<Map> map中的key: id,position_name
     */
    public List<Map<String, String>> getPositionByIDs(String[] positionIds, String dbIdentifier);

}
