package com.horizon.third;
import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.third.service.api.OrgDataCacheApi;
import com.horizon.third.service.api.OrgDataQueryApi;
import com.horizon.third.service.imp.OrgDataCacheService;
import com.horizon.third.service.imp.OrgDataQueryService;

/**
 * @author pengys
 * @date 2022/5/10
 */
public final class OrgDataFactory {
    private static OrgDataCacheApi orgDataCacheApi;
    private static OrgDataQueryApi orgDataQueryApi;
    private OrgDataFactory(){

    }
   public static OrgDataCacheApi getOrgDataCacheManager(){
        if (orgDataCacheApi == null){
            synchronized (OrgDataFactory.class) {
                if (orgDataCacheApi == null) {
                    orgDataCacheApi =  SpringContextHolder.getBean(OrgDataCacheService.class);
                    if (orgDataCacheApi == null){
                        orgDataCacheApi = new OrgDataCacheService();
                    }
                }
            }
        }
       return orgDataCacheApi;
   }
    public static OrgDataQueryApi getOrgDataQueryManager(){
        if (orgDataQueryApi == null){
            synchronized (OrgDataFactory.class) {
                if (orgDataQueryApi == null) {
                    orgDataQueryApi = SpringContextHolder.getBean(OrgDataQueryService.class);
                    if (orgDataQueryApi == null){
                        orgDataQueryApi = new OrgDataQueryService();
                    }
                }
            }
        }
        return orgDataQueryApi;
    }
}
