package com.horizon.third;

/**
 * 身份认证接口类
 * 
 * @author yufang
 *
 */
public interface Identity {

    /**
     * 验证用户是否存在
     * 
     * @param loginName
     *            登陆名
     * @param dbIdentifier
     *            数据源标识
     * @return true:存在 false：不存在
     */
     boolean checkUserExist(String loginName, String dbIdentifier);

    /**
     * 验证用户密码的正确性
     * 
     * @param loginName
     *            登陆名
     * @param password
     *            密码（明文）
     * @param dbIdentifier
     *            数据源标识
     * @return true：符合 false:不符合
     */
     boolean checkUserPass(String loginName, String password, String dbIdentifier);

}
