package com.horizon.third;

import java.util.List;
import java.util.Map;

/**
 * 设计工具与表单的接口
 * 
 * @author liuwx
 *
 */
public interface Form {

	/**
	 * 获得定制表单信息，包括普通表单和图形表单
	 * 
	 * @param para
	 * @param identifier
	 *            数据源标识
	 * @return
	 */
	public String getFormAllInfo(List<String> para, String identifier);

	/**
	 * 根据表单Ids,获得表单对应的字段信息和操作信息
	 * 
	 * @param formids
	 *            表单Id数组
	 * @param identifier
	 *            数据源标识
	 * @return formid~actionid=name|actionid=name,formid~actionid=name|actionid=
	 *         name
	 *         formid~fieldid=name|fieldid=name,formid~fieldid=name|fieldid=name
	 */
	public String getFormInfoByID(List<String> formids, String identifier);

	/**
	 * 获取指定formid的表单包含的字段信息
	 * 
	 * @param formid
	 * @param identifier
	 * @return
	 */
	public List<Map<String, Object>> getFieldsByFormID(String formid, String identifier);

	/**
	 * 获取所有表单信息
	 * 
	 * @param identifier
	 *            数据源标识
	 * @return List[0]: 类型是List,普通表单信息 List[1]: 类型是List,图形表单信息
	 */
	public List<List<List<Object>>> getFormList(String identifier);

	/**
	 * 表单字段权限
	 * 
	 * @param formid
	 *            表单ID
	 * @param identifier
	 *            数据源标识符
	 * @return
	 */
	public List<Map<String, Object>> getFormFieldsAuthByFormId(String formid, String identifier);
}
