package com.horizon.third;

import java.util.List;
import java.util.Map;

/**
 * 流程权限接口
 * 
 * @author mwr
 *
 */
public interface Authority {

    /**
     * 根据流程id获取授权的管理员
     * 
     * @param flowId
     *            流程ID
     * @return
     */
    public String getManager(String flowId);

    /**
     * 判断指定userid是否具有启动flowid流程的权限
     * 
     * @param flowId
     *            流程ID
     * @param userId
     *            用户ID
     * @return
     */
    public boolean isStart(String flowId, String userId);

    /**
     * 判断指定userid是否具有flowid流程的管理员权限
     * 
     * @param flowId
     *            流程ID
     * @param userId
     *            用户ID
     * @return
     */
    public boolean isManager(String flowId, String userId);

    /**
     * 获取指定用户具有设置权限的流程列表
     * 
     * @param userId
     *            当前用户ID
     * @param dbIdentifier
     * @return
     */
    public List<String> getFlowDesignList(String userId, String dbIdentifier);

    /**
     * 获取指定用户具有管理权限的流程列表
     * 
     * @param userid
     *            当前用户ID
     * @param identifier
     * @return
     */
    public List<String> getFlowManageList(String userid, String identifier);

    /**
     * 获得流程启动权限列表
     * 
     * @param userid
     *            当前用户ID
     * @param identifier
     * @return
     */
    public List<String> getFlowStartList(String userid, String identifier);

    /**
     * 初始化权限相关数据
     * 
     * @param userId
     *            用户Id
     * @param dataid
     *            业务数据Id
     * @param resourceType
     *            资源类型 USERMENUOPER 用户菜单操作 ADMINMENUOPER 系统菜单操作 ORGOPER 组织机构
     *            TENANTOPER 租户操作 FLOWOPER 流程操作 ROLEOPER 角色操作
     * @param saveMap
     *            业务的SQLMap key:sql value:List参数方式
     * @param dbIdentifier
     *            数据源标识
     */
    public void authInit(String userId, String dataid, String resourceType, Map<String, List<Object>> saveMap,
            String dbIdentifier);

    /**
     * 删除权限关联数据
     * 
     * @param dataids
     *            业务数据Id
     * @param saveMap
     *            业务的SQLMap
     */
    public void releaseBizPermission(String[] dataids, Map<String, List<List<Object>>> saveMap);

    /**
     * 验证当前用户是否有权限访问该租户
     * 
     * @param userId
     *            用户Id
     * @param tenantCode
     *            租户标识
     * @param dbIdentifier
     *            数据源标识
     * @return true:具有权限 false：不具有权限
     */
    public boolean validateOperatorTenant(String userId, String tenantCode, String dbIdentifier);
}
