/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.designer.wf;

import com.horizon.dom4j.DocumentException;
import com.horizon.dom4j.DocumentHelper;
import com.horizon.dom4j.Element;
import com.horizon.third.Authority;
import com.horizon.third.ThirdAdapterFactory;
import com.horizon.utils.StringUtil;
import com.horizon.wf.definition.FlowDBUtil;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.definition.tools.XMLParseUtil;
import com.horizon.wf.entity.db.DBFlow;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.expand.impl.common.AdapterFactory;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.workflow.designer.wf.vo.WorkFlowDefVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XMLFlowUtil {
    private XMLFlowUtil() {
    }

    public static String getUnid() {
        return UUIDFun.getUnid();
    }

    public static String getCNNameByID(String ids, int flag, String dbIdentifier, String tenantCode, String splitChar) {
        if (!StringUtil.hasValue((String)ids) || "~".equals(ids)) {
            return "~";
        }
        IOrganizationInterface org = PluginsUtil.getMultiInstance().getOrganization(tenantCode);
        String[] idsArr = ids.split("~");
        if (idsArr.length == 1 && idsArr[0].indexOf(splitChar) > -1) {
            idsArr = idsArr[0].split(splitChar);
        }
        List list = new ArrayList();
        String idsNew = "";
        switch (flag) {
            case 1: {
                String[] userArr = new String[idsArr.length];
                String[] localArr = new String[idsArr.length];
                int n = idsArr.length;
                for (int i = 0; i < n; ++i) {
                    int pos = idsArr[i].indexOf("/");
                    if (pos == -1) {
                        userArr[i] = idsArr[i];
                        localArr[i] = "";
                        continue;
                    }
                    userArr[i] = idsArr[i].substring(0, pos);
                    localArr[i] = idsArr[i].substring(pos + 3);
                }
                list = org.getUserByIDs(userArr, dbIdentifier);
                List localList = org.getDeptsByIDs(localArr, dbIdentifier);
                localList.addAll(org.getGroupByIDs(localArr, dbIdentifier));
                localList.addAll(org.getPositionByIDs(localArr, dbIdentifier));
                if (list == null || list.isEmpty()) break;
                for (String tmpID : idsArr) {
                    Map t;
                    int i;
                    String userName = "";
                    String localName = "";
                    int n2 = list.size();
                    for (i = 0; i < n2 && (t = (Map)list.get(i)) != null && t.get("id") != null; ++i) {
                        if (!tmpID.startsWith((String)t.get("id"))) continue;
                        userName = (String)t.get("name");
                        break;
                    }
                    n2 = localList.size();
                    for (i = 0; i < n2 && (t = (Map)localList.get(i)) != null; ++i) {
                        if (tmpID.indexOf("D_" + (String)t.get("id")) != -1) {
                            localName = (String)t.get("dept_name");
                            break;
                        }
                        if (tmpID.indexOf("G_" + (String)t.get("id") + "") != -1) {
                            localName = (String)t.get("group_name");
                            break;
                        }
                        if (tmpID.indexOf("P_" + (String)t.get("id") + "") == -1) continue;
                        localName = (String)t.get("position_name");
                        break;
                    }
                    String tmpName = tmpID + "=" + userName + "(" + ("".equals(localName) ? "\u7528\u6237" : localName) + ")";
                    idsNew = idsNew + tmpName + splitChar;
                }
                break;
            }
            case 2: {
                Map t;
                String[] idsArrNew = new String[idsArr.length];
                int k = idsArr.length;
                for (int m = 0; m < k; ++m) {
                    idsArrNew[m] = idsArr[m].replaceAll("D_", "").replaceAll("S_", "");
                }
                list = org.getDeptsByIDs(idsArrNew, dbIdentifier);
                if (list == null) break;
                int n = list.size();
                for (int i = 0; i < n && (t = (Map)list.get(i)) != null; ++i) {
                    String tmpID = (String)t.get("id");
                    String tmpName = "D_" + tmpID + "=" + (String)t.get("dept_name") + "(\u90e8\u95e8)";
                    String tmpName2 = "S_" + tmpID + "=" + (String)t.get("dept_name") + "(\u90e8\u95e8)";
                    idsNew = idsNew + tmpName + splitChar + tmpName2 + splitChar;
                }
                break;
            }
            case 3: {
                Map t;
                list = org.getGroupByIDs(idsArr, dbIdentifier);
                if (list == null) break;
                int n = list.size();
                for (int i = 0; i < n && (t = (Map)list.get(i)) != null; ++i) {
                    String tmpID = (String)t.get("id");
                    String tmpName = tmpID + "=" + (String)t.get("group_name") + "(\u7fa4\u7ec4)";
                    idsNew = idsNew + tmpName + splitChar;
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Map t;
                int i;
                for (i = 0; i < idsArr.length; ++i) {
                    if (idsArr[i].indexOf(":") <= -1) continue;
                    idsArr[i] = idsArr[i].substring(0, idsArr[i].indexOf(":"));
                }
                list = org.getPositionByIDs(idsArr, dbIdentifier);
                if (list == null) break;
                int n = list.size();
                for (i = 0; i < n && (t = (Map)list.get(i)) != null; ++i) {
                    String tmpID = (String)t.get("id");
                    String tmpName = tmpID + "=" + (String)t.get("position_name") + "(\u5c97\u4f4d)";
                    idsNew = idsNew + tmpName + splitChar;
                }
                break;
            }
        }
        list = null;
        org = null;
        return idsNew;
    }

    public static List getFlowDesignList(String tenantCode, String userId, String dbIdentifier) {
        Authority authority = ThirdAdapterFactory.getAuthorityInstance((String)tenantCode);
        List rList = authority.getFlowDesignList(userId, dbIdentifier);
        if (rList == null || rList.isEmpty()) {
            return new ArrayList(0);
        }
        StringBuffer mysql = new StringBuffer();
        for (int i = 0; i < rList.size(); ++i) {
            if (i == 0) {
                mysql.append("?");
                continue;
            }
            mysql.append(",?");
        }
        String sql = "select distinct def.id,def.flowid,def.flowname,def.type,def.typename,def.version  from TW_HZ_FLOW_DEF def  where def.VERSION =   (SELECT MAX(VERSION) FROM TW_HZ_FLOW_DEF WHERE FLOWID = def.FlowID)";
        sql = sql + " and def.FlowID in ( " + mysql.toString() + " ) order by def.typename";
        ArrayList lst = AccessUtil.getInstance().getMultiObject(sql, rList, WorkFlowDefVO.class, dbIdentifier);
        if (lst == null) {
            lst = new ArrayList(1);
        }
        return lst;
    }

    public static List<Map<String, Object>> getAllFlowMap(String userids, String identifier) {
        List rList = AccessUtil.getInstance().getMultiMap("select a.flowid,a.flowname,a.version,a.type from TW_HZ_FLOW_DEF a where a.version=(select max(version) from TW_HZ_FLOW_DEF where flowid=a.flowid) ", null, identifier);
        return rList;
    }

    public static List<Map<String, Object>> getFlowCatMap(String userids, String identifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.type,a.typename from TW_HZ_FLOW_DEF a where 1=1 ");
        List rList = AccessUtil.getInstance().getMultiMap(sb.toString(), null, identifier);
        return rList;
    }

    public static int checkFlowIDNum(String flowID, String identifier) {
        ArrayList<String> lst = new ArrayList<String>(1);
        lst.add(flowID);
        int num = AccessUtil.getInstance().getRsCount("select id from TW_HZ_FLOW_DEF where flowid=? ", lst, identifier);
        return num;
    }

    private static String getPara(String ids, List<String> lst) {
        String[] tmpArr = ids.split(",");
        return XMLFlowUtil.getPara(tmpArr, lst);
    }

    private static String getPara(String[] idArr, List<String> lst) {
        StringBuilder sb = new StringBuilder();
        int n = idArr.length;
        for (int i = 0; i < n; ++i) {
            if (idArr[i].trim().length() == 0) continue;
            lst.add(idArr[i]);
            sb.append(",?");
        }
        sb.deleteCharAt(0);
        if (sb.length() > 1) {
            sb.insert(0, " in (").append(")");
        } else {
            sb.insert(0, " = ");
        }
        return sb.toString();
    }

    public static DBFlow getMaxFlow(String flowid, String identifier) {
        return FlowDBUtil.getMaxVerFlow((String)flowid, (String)identifier);
    }

    public static String deleteFlow(String flowid, String var, String dbIdentifier, String tenantCode) {
        boolean result = FlowDBUtil.deleteFlows((String)flowid, (String)var, (String)dbIdentifier);
        if (result) {
            String[] flowids = new String[]{flowid};
            LinkedHashMap saveMap = new LinkedHashMap();
            AccessUtil.getInstance().executeMultiUpdate(saveMap, dbIdentifier);
        }
        return String.valueOf(result);
    }

    public static String saveFlow(HZElement flowXML, String saveFlag, String vendorid, String tenantCode, String dbIdentifier) {
        LinkedHashMap<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
        String unid = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"id");
        String flowid = XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/FlowID");
        String activeFlag = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"ActiveFlag");
        int nowver = Integer.parseInt(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Version"));
        int maxver = 0;
        if (!StringUtil.hasValue((String)flowid)) {
            return "";
        }
        DBFlow xFlow = XMLFlowUtil.getMaxFlow(flowid, dbIdentifier);
        boolean isNew = false;
        if (xFlow == null) {
            xFlow = new DBFlow();
            xFlow.setId(unid);
            xFlow.setVersion(0);
            xFlow.setFlowid(flowid);
            isNew = true;
        }
        if (!StringUtil.hasValue((String)unid)) {
            unid = XMLFlowUtil.getUnid();
            nowver = xFlow.getVersion();
            nowver = nowver == 0 ? 1 : ++nowver;
        } else {
            maxver = xFlow.getVersion();
            if ("2".equals(saveFlag)) {
                unid = XMLFlowUtil.getUnid();
                nowver = maxver + 1;
            } else if (maxver == nowver) {
                if (!xFlow.getId().equals(unid)) {
                    unid = XMLFlowUtil.getUnid();
                    nowver = maxver + 1;
                }
            } else {
                unid = XMLFlowUtil.getUnid();
                nowver = maxver + 1;
            }
        }
        if (!StringUtil.hasValue((String)xFlow.getCreator())) {
            xFlow.setCreated(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Created"));
            xFlow.setCreator(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Vendor"));
        }
        xFlow.setModified(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Modified"));
        xFlow.setModificator(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Update"));
        xFlow.setId(unid);
        xFlow.setVersion(nowver);
        xFlow.setActive(Integer.parseInt(activeFlag));
        xFlow.setFlowname(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/FlowName"));
        xFlow.setType(XMLParseUtil.getAttribute((HZElement)flowXML, (String)"TypeDeclarations/Type", (String)"ID"));
        xFlow.setTypename(XMLParseUtil.getTextTrim((HZElement)flowXML, (String)"TypeDeclarations/Type"));
        xFlow.setXml("");
        XMLParseUtil.setAttribute((HZElement)flowXML, (String)"id", (String)xFlow.getId());
        XMLParseUtil.setText((HZElement)flowXML, (String)"TypeDeclarations/Version", (String)(nowver + ""));
        if (isNew && StringUtil.hasValue((String)vendorid)) {
            Authority authority = ThirdAdapterFactory.getAuthorityInstance((String)tenantCode);
            authority.authInit(vendorid, flowid, "FLOWOPER", saveMap, dbIdentifier);
        }
        XMLFlowUtil.startType(flowXML, saveMap, flowid, tenantCode, dbIdentifier);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(flowXML.asXML());
        xFlow.setXml(sb.toString());
        xFlow.setFlowXML(flowXML);
        String result = FlowDBUtil.saveFlow((DBFlow)xFlow, (String)tenantCode, (String)dbIdentifier);
        if (result.equals(xFlow.getFlowid())) {
            boolean flag = AccessUtil.getInstance().executeMultiUpdate(saveMap, dbIdentifier);
            if (flag) {
                return xFlow.getId() + "^" + xFlow.getVersion();
            }
        } else if ("0".equals(result)) {
            return result;
        }
        return "";
    }

    private static void startType(HZElement flowXML, Map<String, List<Object>> saveMap, String flowid, String tenantCode, String identifier) {
        ITaskInterface taskImpl = AdapterFactory.getTaskInterface();
        taskImpl.deleteFlowStartTask(flowid);
        saveMap.put("delete from TW_HZ_MSG_TRIGGER where FLOWID='" + flowid + "' and MESSAGE_TYPE='flowStart'", null);
        saveMap.put("delete from TW_HZ_SIGNAL_TRIGGER where FLOWID='" + flowid + "' and SIGNAL_TYPE='flowStart'", null);
        String msgSql = "";
        ArrayList<String> sqlpara = new ArrayList<String>();
        String startType = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode", (String)"type");
        startType = startType.equals("") ? "0" : startType;
        String activeFlag = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"ActiveFlag");
        if ("1".equals(activeFlag)) {
            int startTypeInt = Integer.parseInt(startType);
            if (startTypeInt == 1) {
                String dataTime = XMLParseUtil.getText((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TimeDate");
                String cycle = XMLParseUtil.getText((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TimeCycle");
                if (cycle == null || "".equals(cycle)) {
                    cycle = "0";
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("startTime", dataTime);
                map.put("repeatInterval", cycle);
                map.put("flowid", flowid);
                map.put("identifier", identifier);
                map.put("tenantid", tenantCode);
                taskImpl.addFlowStartTask(map);
            } else if (startTypeInt == 3) {
                String msgid = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TriggerMessage", (String)"id");
                String msgname = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TriggerMessage", (String)"name");
                String msgfrom = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TriggerMessage", (String)"msgfrom");
                String msgto = XMLParseUtil.getAttribute((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TriggerMessage", (String)"msgto");
                String para = XMLParseUtil.getText((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/StartMode/TriggerMessage/ActualParameters");
                msgSql = "insert into TW_HZ_MSG_TRIGGER(ID,MESSAGE_TYPE,MESSAGE_ID,MESSAGE_NAME,MESSAGE_FROM,MESSAGE_TO,MESSAGE_PARA,FLOWID,status) VALUES(?,?,?,?,?,?,?,?,?)";
                sqlpara.add(XMLFlowUtil.getUnid());
                sqlpara.add("flowStart");
                sqlpara.add(msgid);
                sqlpara.add(msgname);
                sqlpara.add(msgfrom);
                sqlpara.add(msgto);
                sqlpara.add(para);
                sqlpara.add(flowid);
                sqlpara.add("1");
            } else if (startTypeInt == 2) {
                String para = XMLParseUtil.getText((HZElement)flowXML, (String)"WorkflowProcesses/WorkflowProcess[@ID='Start']/EventFlowVar");
                msgSql = "insert into TW_HZ_SIGNAL_TRIGGER(ID,FLOWID,signal_type,signal_para,status) VALUES(?,?,?,?,?)";
                sqlpara.add(XMLFlowUtil.getUnid());
                sqlpara.add(flowid);
                sqlpara.add("flowStart");
                sqlpara.add(para);
                sqlpara.add("1");
            }
        }
        if (StringUtil.hasValue((String)msgSql)) {
            saveMap.put(msgSql, sqlpara);
        }
    }

    public static String saveWork(HZElement workXML, String saveFlag, String workid, String tenantCode, String identifier) {
        String flowid = XMLParseUtil.getTextTrim((HZElement)workXML, (String)"TypeDeclarations/FlowID");
        String nowver = XMLParseUtil.getTextTrim((HZElement)workXML, (String)"TypeDeclarations/Version");
        String flowname = XMLParseUtil.getTextTrim((HZElement)workXML, (String)"TypeDeclarations/FlowName");
        DBWork xWork = new DBWork();
        xWork.setId(workid);
        xWork.setFlowname(flowname);
        xWork.setFlowver(Integer.parseInt(nowver));
        LinkedHashMap saveMap = new LinkedHashMap();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(workXML.asXML());
        xWork.setWorkxml(sb.toString());
        if (XmlDBUtil.saveWorkXmlForSwf((DBWork)xWork, saveMap, (String)tenantCode, (String)identifier)) {
            return flowid + "^" + nowver;
        }
        return "";
    }

    public static List<List<String>> checkXMLFlow(String xml, String dbIdentifier) {
        ArrayList<List<String>> rs = new ArrayList<List<String>>(2);
        Element workXML = null;
        try {
            workXML = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        ArrayList<String> warnList = new ArrayList<String>();
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> outList = new ArrayList<String>();
        boolean manualStart = true;
        boolean hasEndNodes = false;
        Element e = (Element)workXML.selectSingleNode("WorkflowProcesses/WorkflowProcess[@ID='Start']");
        if (e == null) {
            errorList.add("\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
        } else {
            manualStart = e.attribute("Type").getStringValue().equals(String.valueOf(0));
            if (!manualStart) {
                List toRouter = e.selectNodes("Transitions/ToRouter/Router[@ID]");
                for (Element elementNode : toRouter) {
                    Element toNode = (Element)workXML.selectSingleNode("WorkflowProcesses/WorkflowProcess[@ID='" + elementNode.attribute("NodeID").getStringValue() + "']");
                    if (toNode.selectSingleNode("/Buttons/Action[@id='reject']") == null) continue;
                    errorList.add("\u4e0d\u5141\u8bb8" + toNode.attribute("Name").getStringValue() + "\u8282\u70b9\u76f4\u63a5\u9000\u56de\u5230\u975e\u4eba\u5de5\u5f00\u59cb\u8282\u70b9");
                }
            }
        }
        List elementNodes = workXML.selectNodes("WorkflowProcesses/WorkflowProcess");
        Iterator iter = elementNodes.iterator();
        boolean hasVirtual = false;
        while (iter.hasNext()) {
            List toRouter;
            String nodeid;
            Element elementNode;
            block15: {
                block14: {
                    elementNode = (Element)iter.next();
                    nodeid = elementNode.attribute("ID").getStringValue();
                    if (!hasEndNodes && nodeid.startsWith("End")) {
                        hasEndNodes = true;
                    }
                    if ((e = (Element)workXML.selectSingleNode("MapXML/line[@toID='" + nodeid + "']")) != null) break block14;
                    if ("Start".equals(nodeid) || nodeid.startsWith("Virtual")) break block15;
                    warnList.add(elementNode.attribute("Name").getStringValue() + "\u8282\u70b9\u6ca1\u6709\u6d41\u5165\u8def\u7531");
                    break block15;
                }
                if (e.attribute("fromID").getStringValue().startsWith("Virtual")) {
                    hasVirtual = true;
                } else {
                    List allToId = workXML.selectNodes("MapXML/line[@toID='" + nodeid + "']");
                    for (Element toLine : allToId) {
                        if (!toLine.attribute("fromID").getStringValue().startsWith("Virtual")) continue;
                        hasVirtual = true;
                        break;
                    }
                }
            }
            if ((toRouter = elementNode.selectNodes("Transitions/ToRouter/Router[@ID]")) == null || toRouter.isEmpty() && !nodeid.startsWith("End")) {
                if (hasVirtual) continue;
                outList.add(elementNode.attribute("Name").getStringValue() + "\u8282\u70b9\u6ca1\u6709\u6d41\u51fa\u8def\u7531");
                continue;
            }
            if (manualStart || elementNode.selectSingleNode("Transitions/ToRouter/Router[@NodeID='Start']") == null) continue;
            errorList.add("\u4e0d\u5141\u8bb8" + elementNode.attribute("Name").getStringValue() + "\u8def\u7531\u6307\u5411\u975e\u4eba\u5de5\u5f00\u59cb\u8282\u70b9");
        }
        if (!hasEndNodes) {
            errorList.add("\u6d41\u7a0b\u6ca1\u6709\u7ed3\u675f\u8282\u70b9");
        }
        rs.add(warnList);
        if (!hasVirtual) {
            rs.add(outList);
        }
        rs.add(errorList);
        return rs;
    }

    public static String saveNodeModule(String name, String fix, String xml, String dbIdentifier) {
        return FlowDBUtil.saveNodeModule((String)name, (String)fix, (String)xml, (String)dbIdentifier);
    }

    public static List<Map<String, Object>> getNodeModuleList(String nodeidfix, String dbIdentifier) {
        return FlowDBUtil.getNodeModuleList((String)nodeidfix, (String)dbIdentifier);
    }

    public static boolean delNodeModule(String id, String dbIdentifier) {
        return FlowDBUtil.delNodeModule((String)id, (String)dbIdentifier);
    }
}

