/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.designer.wf;

import com.horizon.wf.definition.tools.UUIDFun;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.form.FormInfo;
import com.horizon.wf.rule.form.IFormInfo;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.workflow.designer.wf.vo.TableFieldAuthVO;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class XMLFlowFormUtil {
    private static XMLFlowFormUtil singleClass = null;
    IFormInfo form;
    private final String Table_FieldAuth = "TW_HZ_FORM_FIELDAUTH";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMLFlowFormUtil getInstance() {
        if (singleClass != null) return singleClass;
        Class<XMLFlowFormUtil> clazz = XMLFlowFormUtil.class;
        synchronized (XMLFlowFormUtil.class) {
            if (singleClass != null) return singleClass;
            singleClass = new XMLFlowFormUtil();
            XMLFlowFormUtil.singleClass.form = PluginsUtil.getSingleInstance().getFormInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleClass;
        }
    }

    private XMLFlowFormUtil() {
    }

    public List<FormInfo> loadFormList(String identifier) {
        try {
            List result = this.form.loadFormList(identifier);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFiledAndActionByFormId(List<String> formidLst, String identifier) {
        try {
            String result = this.form.getFiledAndActionByFormId(formidLst, identifier);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public TableFieldAuthVO getFieldAuthById(String authId, String identifier) {
        String sql = "SELECT * FROM TW_HZ_FORM_FIELDAUTH WHERE ID=? ";
        ArrayList<String> para = new ArrayList<String>(1);
        para.add(authId);
        TableFieldAuthVO vo = (TableFieldAuthVO)AccessUtil.getInstance().getSingleObject(sql, para, TableFieldAuthVO.class, identifier);
        return vo;
    }

    public List<List<TableFieldAuthVO>> getAllFieldAuthsByFormid(List<String> forms, String identifier) {
        ArrayList<List<TableFieldAuthVO>> rs = new ArrayList<List<TableFieldAuthVO>>();
        for (int i = 0; i < forms.size(); ++i) {
            String formid = forms.get(i);
            List<Object> outFormFieldAuthList = new ArrayList();
            outFormFieldAuthList = this.getFormFieldAuthDefineList(formid, identifier);
            TableFieldAuthVO f1 = new TableFieldAuthVO();
            f1.setAuthName("\u5168\u53ea\u8bfb");
            f1.setId("allreadonly");
            f1.setFormid(formid);
            TableFieldAuthVO f2 = new TableFieldAuthVO();
            f2.setAuthName("\u5168\u7f16\u8f91");
            f2.setId("alleditable");
            f2.setFormid(formid);
            outFormFieldAuthList.add(0, f2);
            outFormFieldAuthList.add(1, f1);
            rs.add(outFormFieldAuthList);
        }
        return rs;
    }

    public List<TableFieldAuthVO> getFormFieldAuthDefineList(String formid, String dbIdentifier) {
        String sql = "SELECT * FROM TW_HZ_FORM_FIELDAUTH WHERE FORMID=? ORDER BY AUTH_NAME";
        ArrayList<String> para = new ArrayList<String>(1);
        para.add(formid);
        List rList = AccessUtil.getInstance().getMultiObject(sql, para, TableFieldAuthVO.class, dbIdentifier);
        return rList;
    }

    public boolean validFormFieldsAuthRepeat(String fieldAuthName, String formid, String id, String dbIdentifier) {
        String sql = "SELECT ID FROM TW_HZ_FORM_FIELDAUTH WHERE FORMID=? AND AUTH_NAME=? AND ID!=?";
        ArrayList<String> lstConditions = new ArrayList<String>();
        lstConditions.add(formid);
        lstConditions.add(fieldAuthName);
        lstConditions.add(id);
        return AccessUtil.getInstance().getRsCount(sql, lstConditions, dbIdentifier) > 0;
    }

    public String saveFormFieldDefineInfo(TableFieldAuthVO vo, String dbIdentifier) {
        LinkedHashMap map = new LinkedHashMap();
        String delSQL = "DELETE FROM TW_HZ_FORM_FIELDAUTH WHERE ID=?";
        ArrayList<String> delpara = new ArrayList<String>(1);
        delpara.add(vo.getId());
        map.put(delSQL, delpara);
        String insertSQL = "INSERT INTO TW_HZ_FORM_FIELDAUTH(ID,FORMID,AUTH_NAME,AUTH_CODE,TABLEID,EDITFIELD,CHECKFIELD,READFIELD,HIDDENFIELD,AUTHFLAG) values(?,?,?,?,?,?,?,?,?,?)";
        if (vo.getId() == null || vo.getId().length() != 32) {
            vo.setId(UUIDFun.getUnid());
        }
        ArrayList<String> dlst = new ArrayList<String>();
        dlst.add(vo.getId());
        dlst.add(vo.getFormid());
        dlst.add(vo.getAuthName());
        dlst.add(vo.getAuthCode());
        dlst.add(vo.getTableid());
        dlst.add(vo.getEditfield());
        dlst.add(vo.getCheckfield());
        dlst.add(vo.getReadfield());
        dlst.add(vo.getHiddenfield());
        dlst.add(vo.getAuthflag());
        map.put(insertSQL, dlst);
        if (AccessUtil.getInstance().executeMultiUpdate(map, dbIdentifier)) {
            return vo.getId();
        }
        return "";
    }
}

