/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.designer.wf;

import com.horizon.dom4j.DocumentException;
import com.horizon.dom4j.DocumentHelper;
import com.horizon.dom4j.Element;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.autotest.AutoTestMain;
import com.horizon.wf.autotest.vo.BackVo;
import com.horizon.wf.core.mem.MemCacheUtil;
import com.horizon.wf.definition.FlowDBUtil;
import com.horizon.wf.definition.FlowDefinitionUtil;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.definition.api.XMLFlowInfo;
import com.horizon.wf.definition.tools.HZElement;
import com.horizon.wf.definition.tools.XMLParseUtil;
import com.horizon.wf.entity.db.DBFlow;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.rule.form.FormInfo;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.StringUtil;
import com.horizon.workflow.designer.flex.FlexService;
import com.horizon.workflow.designer.wf.XMLFlowFormUtil;
import com.horizon.workflow.designer.wf.XMLFlowUtil;
import com.horizon.workflow.designer.wf.business.FileUtil;
import com.horizon.workflow.designer.wf.vo.InstanceNumVO;
import com.horizon.workflow.designer.wf.vo.TableFieldAuthVO;
import com.horizon.workflow.designer.wf.vo.WorkFlowDefVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkFlow
extends FlexService {
    public List getFlowList(String tenantCode, String userId, String dbIdentifier) {
        return XMLFlowUtil.getFlowDesignList(tenantCode, userId, dbIdentifier);
    }

    public String getXMLFlow(List<?> para, String identifier) {
        String flowid = (String)para.get(0);
        String ver = para.size() > 1 ? (String)para.get(1) : null;
        String flowXML = "";
        if (flowid != null && ver != null) {
            DBFlow xFlow = FlowDBUtil.getFlowByVer((String)flowid, (String)ver, (String)identifier);
            if (xFlow != null) {
                flowXML = xFlow.getXml();
            }
        } else if (flowid != null) {
            DBFlow xFlow = FlowDBUtil.getMaxVerFlow((String)flowid, (String)identifier);
            if (xFlow != null) {
                flowXML = xFlow.getXml();
            }
        } else {
            flowXML = "";
        }
        return flowXML;
    }

    public List getCnName(List para, String dbIdentifier, String tenantCode) {
        return this.getCnName(para, dbIdentifier, tenantCode, ";");
    }

    public List getCnName(List para, String dbIdentifier, String tenantCode, String splitChar) {
        ArrayList<String> back = new ArrayList<String>(4);
        back.add(XMLFlowUtil.getCNNameByID((String)para.get(0), 1, dbIdentifier, tenantCode, splitChar));
        back.add(XMLFlowUtil.getCNNameByID((String)para.get(1), 2, dbIdentifier, tenantCode, splitChar));
        back.add(XMLFlowUtil.getCNNameByID((String)para.get(2), 3, dbIdentifier, tenantCode, splitChar));
        back.add(XMLFlowUtil.getCNNameByID((String)para.get(3), 4, dbIdentifier, tenantCode, splitChar));
        back.add(XMLFlowUtil.getCNNameByID((String)para.get(4), 5, dbIdentifier, tenantCode, splitChar));
        return back;
    }

    public String saveFlow(List para, String tenantCode, String dbIdentifier) {
        String saveFlag = (String)para.get(0);
        HZElement workXML = XMLParseUtil.convertStringToXML((String)((String)para.get(1)));
        String vendorid = (String)para.get(2);
        String rs = "";
        try {
            rs = XMLFlowUtil.saveFlow(workXML, saveFlag, vendorid, tenantCode, dbIdentifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    public String saveNodeModule(String name, String fix, String xml, String dbIdentifier) {
        return XMLFlowUtil.saveNodeModule(name, fix, xml, dbIdentifier);
    }

    public List<Map<String, Object>> getNodeModuleList(String nodeidfix, String dbIdentifier) {
        return XMLFlowUtil.getNodeModuleList(nodeidfix, dbIdentifier);
    }

    public boolean delNodeModule(String id, String dbIdentifier) {
        return XMLFlowUtil.delNodeModule(id, dbIdentifier);
    }

    public String deleteFlow(String flowid, String dbIdentifier, String tenantCode) {
        return this.deleteFlow(flowid, null, dbIdentifier, tenantCode);
    }

    public String deleteFlow(String flowid, String var, String dbIdentifier, String tenantCode) {
        return XMLFlowUtil.deleteFlow(flowid, var, dbIdentifier, tenantCode);
    }

    public String getMapXMLString(String workid, String flowid, String version, String tenentcode, String identifier) {
        String rs = "";
        try {
            if (workid != null && workid.length() > 0) {
                rs = XmlDBUtil.getMapXMLString((String)workid, (String)tenentcode, (String)identifier);
            } else if (flowid != null && flowid.length() > 0) {
                FlowDefinitionUtil flow = new FlowDefinitionUtil("", "");
                XMLFlowInfo f = flow.getFlow(flowid, version, identifier);
                rs = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><FlowMap>" + f.getMapXML() + "<Map><NowNodes/><DoneNodes/></Map></FlowMap>";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    public BackVo test_StartInstance(String flowid, String userid, String tenantid, String identifier) {
        BackVo vo = AutoTestMain.getInstance().startInstance(flowid, userid, tenantid, identifier);
        return vo;
    }

    public BackVo test_StartInstance(String flowid, String userid, boolean saveToDB, String tenantid, String identifier) {
        BackVo vo = AutoTestMain.getInstance().startInstance(flowid, userid, saveToDB, tenantid, identifier);
        return vo;
    }

    public BackVo test_Submit(String workid, String nodeid) {
        BackVo vo = AutoTestMain.getInstance().submit(workid, nodeid);
        return vo;
    }

    public BackVo test_SubmitContinue(String workid, String selectNodeids, String selectUserids) {
        BackVo vo = AutoTestMain.getInstance().submitContinue(workid, selectNodeids, selectUserids);
        return vo;
    }

    public BackVo test_Claim(String workid, String userid) {
        BackVo vo = AutoTestMain.getInstance().claim(workid, userid);
        return vo;
    }

    public void clearFromMap(String workid) {
        AutoTestMain.getInstance().clearFromMap(workid);
    }

    public String XMLencode(String str) {
        return StringUtil.encode((String)str);
    }

    public List<InstanceNumVO> getFlowInstanceNum(String flowid, String identifier) {
        String sql = "SELECT NODEID,NODENAME,count(nodeid) as SUMNUM " + " from tw_hz_track a,tw_hz_instance b where a.workid=b.id and flowid=? group by nodeid,NODENAME".toUpperCase();
        ArrayList<String> para = new ArrayList<String>(1);
        para.add(flowid);
        List rs = AccessUtil.getInstance().getMultiObject(sql, para, InstanceNumVO.class, identifier);
        return rs;
    }

    public String checkFlowID(String flowid, String identifier) {
        return String.valueOf(XMLFlowUtil.checkFlowIDNum(flowid, identifier));
    }

    public String getExportFlow(String flowid, String identifier) {
        DBFlow xFlow = FlowDBUtil.getMaxVerFlow((String)flowid, (String)identifier);
        String flowXML = "";
        if (xFlow != null) {
            flowXML = xFlow.getXml();
        }
        return flowXML;
    }

    public List<List<Map<String, Object>>> getAllFlowList(String userids, String identifier) {
        List<Map<String, Object>> flowlist = XMLFlowUtil.getAllFlowMap(userids, identifier);
        List<Map<String, Object>> catlist = XMLFlowUtil.getFlowCatMap(userids, identifier);
        ArrayList<List<Map<String, Object>>> back = new ArrayList<List<Map<String, Object>>>(2);
        back.add(flowlist);
        back.add(catlist);
        return back;
    }

    public List<?> getFileList(String path) {
        return FileUtil.getInstance().getFileList(path);
    }

    public String getXMLWork(List para, String identifier) {
        return this.getXMLWork(para, null, identifier);
    }

    public String getXMLWork(List para, String tenantid, String identifier) {
        String workid = (String)para.get(0);
        String flowXML = XmlDBUtil.getWorkXmlByIdForSwf((String)workid, (String)tenantid, (String)identifier);
        return flowXML;
    }

    public String saveWork(List para, String tenantCode, String identifier) {
        String saveFlag = (String)para.get(0);
        HZElement workXML = XMLParseUtil.convertStringToXML((String)((String)para.get(1)));
        String workid = (String)para.get(2);
        return XMLFlowUtil.saveWork(workXML, saveFlag, workid, tenantCode, identifier);
    }

    public List<List<String>> checkXMLFlow(String xml, String identifier) {
        List<List<String>> rs = XMLFlowUtil.checkXMLFlow(xml, identifier);
        return rs;
    }

    public List<List<String>> getFlowVars(String flowid, String identifier) {
        ArrayList<List<String>> rs = new ArrayList<List<String>>(2);
        ArrayList<String> para = new ArrayList<String>(2);
        para.add(flowid);
        String xml = this.getXMLFlow(para, identifier);
        if ("".equals(xml)) {
            return null;
        }
        Element workXML = null;
        try {
            workXML = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        List elementNodes = workXML.selectNodes("TypeDeclarations/Vars/*");
        Iterator iter = elementNodes.iterator();
        while (iter.hasNext()) {
            ArrayList<String> temp = new ArrayList<String>(2);
            Element elementNode = (Element)iter.next();
            temp.add(elementNode.attribute("name").getStringValue());
            temp.add(elementNode.attribute("id").getStringValue());
            rs.add(temp);
        }
        return rs;
    }

    public List<DBLog> getFolwHistoryList(String workid, String identifier) {
        IWorkflowOperator wo = WorkflowFactory.getWorkFlowOperator();
        return wo.getHistory(workid, identifier);
    }

    public List getSubFolwList(String parentworkid, String identifier) {
        return this.getSubFolwList(parentworkid, null, identifier);
    }

    public List getSubFolwList(String parentworkid, String tenantid, String identifier) {
        ArrayList list = new ArrayList(2);
        String xml = XmlDBUtil.getWorkXmlByIdForSwf((String)parentworkid, (String)tenantid, (String)identifier);
        Element workXML = null;
        try {
            workXML = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        List elementNodes = workXML.selectNodes("WorkflowProcesses/WorkflowProcess");
        for (Element elementNode : elementNodes) {
            String parentnodeid = elementNode.attribute("ID").getStringValue();
            String parentnodename = elementNode.attribute("Name").getStringValue();
            for (Element tmp : elementNode.selectNodes("SubFlow/Flow")) {
                String flowid = tmp.attributeValue("ID");
                String flowname = tmp.attributeValue("Name");
                String flowidentifier = identifier;
                String sql = "SELECT T.ID,T.TITLE,T.STARTTIME FROM TW_HZ_INSTANCE T,TWR_HZ_SUBFLOW T2 WHERE T.ID=T2.SUBWORKID AND T2.WORKID=? AND T2.NODEID=? AND T2.SUBFLOWID=?";
                ArrayList<String> para = new ArrayList<String>();
                para.add(parentworkid);
                para.add(parentnodeid);
                para.add(flowid);
                List sqlList = AccessUtil.getInstance().getMultiList(sql, para, flowidentifier);
                if (sqlList != null && !sqlList.isEmpty()) {
                    int j = sqlList.size();
                    for (int i = 0; i < j; ++i) {
                        List tmpList = (List)sqlList.get(i);
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("parentnodeid", parentnodeid);
                        map.put("parentnodename", parentnodename);
                        map.put("flowidentifier", flowidentifier);
                        map.put("flowid", flowid);
                        map.put("flowname", flowname);
                        map.put("workid", tmpList.get(0));
                        map.put("title", tmpList.get(1));
                        map.put("starttime", tmpList.get(2));
                        map.put("status", true);
                        list.add(map);
                    }
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("parentnodeid", parentnodeid);
                map.put("parentnodename", parentnodename);
                map.put("flowidentifier", flowidentifier);
                map.put("flowid", flowid);
                map.put("flowname", flowname);
                map.put("workid", "");
                map.put("title", "");
                map.put("starttime", "");
                map.put("status", false);
                list.add(map);
            }
        }
        return list;
    }

    public List<WorkFlowDefVO> getModeNameList(String dbIdentifier) {
        String sql = "SELECT DISTINCT TYPENAME FROM TW_HZ_FLOW_DEF";
        List lst = AccessUtil.getInstance().getMultiObject(sql, null, WorkFlowDefVO.class, dbIdentifier);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        ArrayList<WorkFlowDefVO> result = new ArrayList<WorkFlowDefVO>();
        for (WorkFlowDefVO vo : lst) {
            if (vo.getTypename() == null || vo.getTypename().equals("")) continue;
            result.add(vo);
        }
        return result;
    }

    public List<Object> loadMemData(String tenantid) {
        if (tenantid == null || "".equals(tenantid)) {
            return MemCacheUtil.loadMemData();
        }
        return MemCacheUtil.loadMemData((String)tenantid);
    }

    public boolean removeByWorkidsForFlex(String workids) {
        MemCacheUtil.removeByWorkidsForFlex((String)workids);
        return true;
    }

    public List<FormInfo> loadFormList(String identifier) {
        return XMLFlowFormUtil.getInstance().loadFormList(identifier);
    }

    public String getFiledAndActionByFormId(List<String> formidLst, String identifier) {
        return XMLFlowFormUtil.getInstance().getFiledAndActionByFormId(formidLst, identifier);
    }

    public TableFieldAuthVO getFieldAuthById(String authId, String identifier) {
        return XMLFlowFormUtil.getInstance().getFieldAuthById(authId, identifier);
    }

    public List<List<TableFieldAuthVO>> getAllFieldAuthsByFormid(List forms, String identifier) {
        return XMLFlowFormUtil.getInstance().getAllFieldAuthsByFormid(forms, identifier);
    }

    public String saveFormFieldDefineInfo(TableFieldAuthVO vo, String dbIdentifier) {
        boolean isRepeat = XMLFlowFormUtil.getInstance().validFormFieldsAuthRepeat(vo.getAuthName().trim(), vo.getFormid(), vo.getId(), dbIdentifier);
        if (isRepeat) {
            return "saveFormFieldsAuthRepeat";
        }
        return XMLFlowFormUtil.getInstance().saveFormFieldDefineInfo(vo, dbIdentifier);
    }
}

