package com.horizon.boot.web;

import com.alibaba.druid.pool.DruidDataSource;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Maps;
import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.core.context.AbstractContext;
import com.horizon.datasource.DynamicDataSource;
import com.horizon.datasource.config.impl.DatabaseConnectionInfoImpl;
import com.horizon.profile.AppConfig;
import com.horizon.profile.api.ProfileContext;
import com.horizon.utils.ServletContextUtil;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.ServletContext;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

/**
 * 系统启动监听
 *
 * @author mwr
 */
@Component
@Order(1)
public class HorizonWorkflowStartup implements CommandLineRunner {

    private Logger logger = LoggerFactory.getLogger(HorizonWorkflowStartup.class);

    @Value("${appEnvironment.jarPropReadonly}")
    private boolean jarPropReadonly;

    @Override
    public void run(String... strings){

        ServletContext context =ServletContextUtil.getServletContext();
        logger.info("contextpath:"+context.getContextPath());
        initApplicationPath(context);
        //从磁盘用户目录读取属性文件
        initProps();
    }

    /**
     * 配置文件的通配路径
     */
    private void initApplicationPath(ServletContext context) {
        String webPath = null;
        try {
            webPath = getAbsolutePathByResource(context);
        } catch (Exception e) {
        }
        logger.info("  设置系统工程路径");
        AbstractContext abstractContext = new AbstractContext();
        abstractContext.setProjectPath(webPath);
    }

    /**
     * 根据 Resources获得工程路径
     *
     * @return
     * @throws Exception
     */
    private String getAbsolutePathByResource(ServletContext context) throws Exception {

        URL url = context.getResource("/");
        String path = new File(url.toURI()).getAbsolutePath();
        if (!path.endsWith("\\") && !path.endsWith("/")) {
            path += File.separator;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" get Absolute Path By Resource = " + path);
        }
        return path;
    }


    /**
     * 初始化系统属性文件
     */
    private void initProps(){
        logger.info(" 加载系统属性文件");
        //拷贝文件
        ProfileContext.newInstance().buildResources(jarPropReadonly);
        //从磁盘文件读取属性值，重新加载bean
        setBeanFromProperties();
    }

    private void setBeanFromProperties(){

        //引擎数据库基本信息
        DatabaseConnectionInfoImpl databaseConnectionInfo = SpringContextHolder.getBean("systemConnectionInfo");
        Properties properties = AppConfig.getProfile("dbconfig");
        databaseConnectionInfo.setIdentifier(properties.getProperty("horizon.identifier"));
        databaseConnectionInfo.setDatabaseType(properties.getProperty("horizon.databaseType"));
        databaseConnectionInfo.setConnectionType(properties.getProperty("horizon.connectionType"));
        databaseConnectionInfo.setLobProcessorClass(properties.getProperty("horizon.lobProcessorClass"));
        databaseConnectionInfo.setLobBufferSize(Integer.parseInt(properties.getProperty("horizon.lobBufferSize")));
        databaseConnectionInfo.setJndiName(properties.getProperty("horizon.jndiName"));
        databaseConnectionInfo.setIsDefault(Boolean.parseBoolean(properties.getProperty("horizon.isDefault")));
        //工作流引擎连接池配置信息: 1、第三方集成时为可选项;2、独立运行时为必须配置项dbconfigProperties.getDb().get("")
        databaseConnectionInfo.setDriverClass(properties.getProperty("horizon.db.driverClass"));
        databaseConnectionInfo.setUrl(properties.getProperty("horizon.db.jdbcUrl"));
        databaseConnectionInfo.setUserName(properties.getProperty("horizon.db.username"));
        databaseConnectionInfo.setUserPassword(properties.getProperty("horizon.db.password"));
        databaseConnectionInfo.setMaxPoolSize(Integer.parseInt(properties.getProperty("horizon.db.maxPoolSize")));
        databaseConnectionInfo.setMinPoolSize(Integer.parseInt(properties.getProperty("horizon.db.minPoolSize")));
        databaseConnectionInfo.setInitialPoolSize(Integer.parseInt( properties.getProperty("horizon.db.initialPoolSize")));
        databaseConnectionInfo.setMaxIdelTime(Integer.parseInt( properties.getProperty("horizon.db.maxIdelTime")));

        //数据源配置信息
        String datasourceType = databaseConnectionInfo.getDatasourceType();

        //动态数据源配置信息
        DynamicDataSource dynamicDataSource = SpringContextHolder.getBean("horizonDynamicDatasource");
        Map<String,Object> dataSourceMap = Maps.newHashMap();

        if(Objects.equal(datasourceType.toLowerCase(),"druid")){
            DruidDataSource dataSource = SpringContextHolder.getBean("defaultDataSource");
            dataSource.setDriverClassName(properties.getProperty("horizon.db.driverClass"));
            dataSource.setUrl(properties.getProperty("horizon.db.jdbcUrl"));
            dataSource.setUsername(properties.getProperty("horizon.db.username"));
            dataSource.setPassword(properties.getProperty("horizon.db.password"));
            dataSourceMap.put(properties.getProperty("horizon.identifier"),dataSource);
        }else{
            DataSource dataSource = SpringContextHolder.getBean("defaultDataSource");
            dataSource.setDriverClassName(properties.getProperty("horizon.db.driverClass"));
            dataSource.setUrl(properties.getProperty("horizon.db.jdbcUrl"));
            dataSource.setUsername(properties.getProperty("horizon.db.username"));
            dataSource.setPassword(properties.getProperty("horizon.db.password"));
            dataSourceMap.put(properties.getProperty("horizon.identifier"),dataSource);
        }
        dynamicDataSource.setTargetDataSources(dataSourceMap);
    }
}
