package com.horizon.boot.web;

import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.core.init.HorizonInitAble;
import com.horizon.core.init.HorizonInitRegiester;
import com.horizon.language.LanguageUtil;
import com.horizon.license.StartApplication;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

/**
 * 启动预加载项目资源
 *
 * @author mwr
 */
@Component
@Order(2)
public class HorizonWorkflowInit implements CommandLineRunner {

    private Logger logger = LoggerFactory.getLogger(HorizonWorkflowInit.class);

    @Value("${appEnvironment.jarPropReadonly}")
    private boolean jarPropReadonly;

    @Override
    public void run(String... strings) throws Exception {

        logger.info("工作流系统启动  开始");
        // 从spring中获取带@HInit的类
        Map<String, HorizonInitAble> map = SpringContextHolder.getApplicationContext().getBeansOfType(HorizonInitAble.class);
        // 注册到register里
        for (Map.Entry<String, HorizonInitAble> item : map.entrySet()) {
            HorizonInitRegiester.regiest(item.getValue());
        }
        HorizonInitRegiester.start();
        String product = HorizonPorps.getConfig("product");
        String projectPath = null;
        if (jarPropReadonly){
            projectPath = getLicenseAbsolutePath();
        }else {
            String resourcePath = HorizonPorps.getConfig("horizon.home");
            String commonPath = File.separator + product + File.separator +"license" + File.separator;
            if (!StringUtil.hasValue(resourcePath)){
                File file = new File(System.getProperty("user.home"));
                projectPath = file.getCanonicalPath() + commonPath;
            }else {
                projectPath = resourcePath + commonPath;
            }
        }
        StartApplication.start(product, projectPath);
        LanguageUtil.reloadLanguage();
        logger.info("工作流系统启动  结束");
        HorizonInitRegiester.startAfterInit();
    }

    /**
     * 获取license的绝对路径
     * @return
     * @throws IOException
     */
    private String getLicenseAbsolutePath(){
        URL url = this.getClass().getClassLoader().getResource("license.xml");
        String LicenseAbsolutePath = null;
        if (url != null ){
            LicenseAbsolutePath = url.getFile();
        }
        return LicenseAbsolutePath;
    }

}
