package com.horizon.boot.web;

import com.horizon.boot.filter.HorizonDomainFilter;
import com.horizon.common.collect.Maps;
import com.horizon.core.context.ContextListener;
import com.horizon.filter.WorkflowContextFilter;
import com.horizon.wf.config.LoadConfig;
import flex.messaging.MessageBrokerServlet;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * 引擎Mvc配置接口
 *
 * @author malei 2018年6月23日
 *
 */
@Configuration
@ServletComponentScan
public class HorizonMvcConfigAdapter extends WebMvcConfigurerAdapter {

    /**
     * 跨域请求处理
     * @param registry
     */
    @Override
    public void addCorsMappings(CorsRegistry registry) {

        registry.addMapping("/**")
                .allowCredentials(true)
                .allowedHeaders("*")
                .allowedOrigins("*")
                .allowedMethods("*");

    }

    /**
     * 默认首页
     * @param registry
     */
    public void addViewControllers(ViewControllerRegistry registry) {

        registry.addViewController("/").setViewName("forward:/welcome.html");
        registry.setOrder(Ordered.HIGHEST_PRECEDENCE);
        super.addViewControllers(registry);
    }
    /**
     * flex流程servlet配置
     * @return
     */
    @Bean
    public ServletRegistrationBean servletRegistrationBean() {

        Map<String,String> initParam= Maps.newHashMap();
        initParam.put("services.configuration.file", "services-config.xml");
        ServletRegistrationBean registration = new ServletRegistrationBean();
        registration.addUrlMappings("/messagebroker/*");
        registration.setName("messageBroker");
        registration.setServlet(new MessageBrokerServlet());
        registration.setOrder(0);
        registration.setInitParameters(initParam);
        return registration;
    }

    /**
     * license注册servlet
     * @return
     */
    @Bean
    public ServletRegistrationBean workflowServletRegistrationBean(){

        ServletRegistrationBean registration = new ServletRegistrationBean();
        registration.setServlet(new LoadConfig());
        registration.setName("workflow");
        registration.addUrlMappings("/workflow.hz");
        registration.setOrder(1);
        return registration;
    }

    /**
     * springContext监听
     * @return
     */
    @Bean
    public ServletListenerRegistrationBean ContextListener(){

        ServletListenerRegistrationBean listenerRegistrationBean=new ServletListenerRegistrationBean();
        listenerRegistrationBean.setListener(new ContextListener());
        listenerRegistrationBean.setOrder(0);
        return listenerRegistrationBean;
    }

    /**
     * 保持session一致性过滤器
     * @return
     */
    @Bean
    public FilterRegistrationBean filterRegistrationBean() {

        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        HorizonDomainFilter horizonDomainFilter = new HorizonDomainFilter();
        registrationBean.setFilter(horizonDomainFilter);
        List<String> urlPatterns = new ArrayList<String>();
        urlPatterns.add("/*");
        registrationBean.setUrlPatterns(urlPatterns);
        return registrationBean;
    }

    /**
     * 字符集过滤器
     *
     * @return FilterRegistrationBean
     */
    @Bean
    public FilterRegistrationBean setCharacterEncodingBean() {

        FilterRegistrationBean registrationBeanEncoding = new FilterRegistrationBean();
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        registrationBeanEncoding.setFilter(characterEncodingFilter);
        Map paraMap = Maps.newHashMap();
        paraMap.put("encoding","UTF-8");
        registrationBeanEncoding.setInitParameters(paraMap);
        return registrationBeanEncoding;
        /*CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setEncoding("UTF-8");
        characterEncodingFilter.setForceEncoding(true);
        return characterEncodingFilter;*/
    }

    /**
     *请求过滤器
     * @return
     */
    @Bean
    public FilterRegistrationBean registrationBean() {

        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        WorkflowContextFilter wcf = new WorkflowContextFilter();
        registrationBean.setFilter(wcf);
        registrationBean.addUrlPatterns("*.wf");
        return registrationBean;
    }
}